<?php
namespace PhpUnitsOfMeasure\PhysicalQuantity;

use PhpUnitsOfMeasure\AbstractPhysicalQuantity;
use PhpUnitsOfMeasure\UnitOfMeasure;

class VolumetricFlow extends AbstractPhysicalQuantity
{
    protected static $unitDefinitions;

    protected static function initialize()
    {
        // cubic meters per second
        $metercubedpersecond = UnitOfMeasure::nativeUnitFactory('m^3/s');
        $metercubedpersecond->addAlias('meters^3/sec');
        $metercubedpersecond->addAlias('meters cubed per second');
        $metercubedpersecond->addAlias('meter^3 per second');
        $metercubedpersecond->addAlias('metres cubed per second');
        $metercubedpersecond->addAlias('metre^3 per second');
        static::addUnit($metercubedpersecond);

        // cubic inches per minute
        $newUnit = UnitOfMeasure::linearUnitFactory('in^3/min', 1/3661424.645);
        $newUnit->addAlias('in^3/min');
        $newUnit->addAlias('cubic inches per minute');
        $newUnit->addAlias('inches^3 per minute');
        static::addUnit($newUnit);

        // cubic feet per second
        $newUnit = UnitOfMeasure::linearUnitFactory('ft^3/s', 1/35.314666721489);
        $newUnit->addAlias('cubic feet/sec');
        $newUnit->addAlias('feet cubed per second');
        static::addUnit($newUnit);
	
        // cubic feet per minute
        $newUnit = UnitOfMeasure::linearUnitFactory('ft^3/min', 1/2118.8800032893);
        $newUnit->addAlias('cubic feet/min');
        $newUnit->addAlias('feet cubed per minute');
        static::addUnit($newUnit);

        // liters per hour
        $newUnit = UnitOfMeasure::linearUnitFactory('L/h', 1/3600000);
        $newUnit->addAlias('Liters/hour');
        $newUnit->addAlias('Liters per hour');
        $newUnit->addAlias('Litres/hour');
        $newUnit->addAlias('Litres per hour');
        static::addUnit($newUnit);

        // liters per minute
        $newUnit = UnitOfMeasure::linearUnitFactory('L/min', 1/60000);
        $newUnit->addAlias('Liters/minute');
        $newUnit->addAlias('Liters per minute');
        $newUnit->addAlias('Litres/minute');
        $newUnit->addAlias('Litres per minute');
        static::addUnit($newUnit);

        // milliliters per hour
        $newUnit = UnitOfMeasure::linearUnitFactory('mL/h', 1/3600000000);
        $newUnit->addAlias('milliliters/hour');
        $newUnit->addAlias('milliliters per hour');
        $newUnit->addAlias('millilitres/hour');
        $newUnit->addAlias('millilitres per hour');
        static::addUnit($newUnit);

        // milliliters per minute 
        $newUnit = UnitOfMeasure::linearUnitFactory('mL/min', 1/60000000);
        $newUnit->addAlias('milliliters/minute');
        $newUnit->addAlias('milliliters per minute');
        $newUnit->addAlias('millilitres/minute');
        $newUnit->addAlias('millilitres per minute');
        static::addUnit($newUnit);

        // milliliters per second
        $newUnit = UnitOfMeasure::linearUnitFactory('mL/s', 1/1000000);
        $newUnit->addAlias('milliliters/second');
        $newUnit->addAlias('milliliters per second');
        $newUnit->addAlias('millilitres/second');
        $newUnit->addAlias('millilitres per second');
        static::addUnit($newUnit);

        // gallons per hour
        $newUnit = UnitOfMeasure::linearUnitFactory('US gal/h', 1/951019.38848933);
        $newUnit->addAlias('gal/hour');
        $newUnit->addAlias('gallons per hour');
        static::addUnit($newUnit);

        // gallons per minute
        $newUnit = UnitOfMeasure::linearUnitFactory('US gal/min', 1/15850.323141489);
        $newUnit->addAlias('gal/minute');
        $newUnit->addAlias('gallons per minute');
        static::addUnit($newUnit);
    }
}

