<?php
namespace PhpUnitsOfMeasure\PhysicalQuantity;

use PhpUnitsOfMeasure\AbstractPhysicalQuantity;
use PhpUnitsOfMeasure\UnitOfMeasure;
use PhpUnitsOfMeasure\HasSIUnitsTrait;

class Power extends AbstractPhysicalQuantity
{
    use HasSIUnitsTrait;

    protected static $unitDefinitions;

    protected static function initialize()
    {
        // Watt
        $watt = UnitOfMeasure::nativeUnitFactory('W');
        $watt->addAlias('watt');
        $watt->addAlias('watts');
        static::addUnit($watt);

        static::addMissingSIPrefixedUnits(
            $watt,
            1,
            '%pW',
            [
                '%Pwatt',
                '%Pwatts',
            ]
        );
	
        // BTU/h
        $BTUh = UnitOfMeasure::linearUnitFactory('BTU/h', 0.293047163);
        $BTUh->addAlias('BTU per hour');
        static::addUnit($BTUh);
	
        // Ton
        $Ton= UnitOfMeasure::linearUnitFactory('ToR', 3516.85);
        $Ton->addAlias('Refrigeration Ton');
        static::addUnit($Ton);
    }
}
