<?php
namespace PhpUnitsOfMeasure\PhysicalQuantity;

use PhpUnitsOfMeasure\AbstractPhysicalQuantity;
use PhpUnitsOfMeasure\UnitOfMeasure;
use PhpUnitsOfMeasure\HasSIUnitsTrait;

class LuminousIntensity extends AbstractPhysicalQuantity
{
    use HasSIUnitsTrait;

    protected static $unitDefinitions;

    protected static function initialize()
    {
        //Lux 
        $lux= UnitOfMeasure::nativeUnitFactory('lx');
        $lux->addAlias('lux');
        $lux->addAlias('lm/m^2');
        $lux->addAlias('lumens per meter squared');
        static::addUnit($lux);

	/*
        static::addMissingSIPrefixedUnits(
            $lux,
            1,
            '%plx',
            [
                '%Plux',
            ]
        );
	 */
	
        // Foot-Candle
        $newUnit = UnitOfMeasure::linearUnitFactory('fc', 0.09236803);
        $newUnit->addAlias('foot-candle');
        $newUnit->addAlias('ft-c');
        $newUnit->addAlias('lm/ft^2');
        $newUnit->addAlias('lumens per foot squared');
        static::addUnit($newUnit);
	
        // Foot-Candle
        $newUnit = UnitOfMeasure::linearUnitFactory('phot', 10000);
        $newUnit->addAlias('ph');
        $newUnit->addAlias('lumen/cm^2');
        $newUnit->addAlias('lumens per centimeter squared');
        static::addUnit($newUnit);
	
        // Sunlight PPFD
        $newUnit = UnitOfMeasure::linearUnitFactory('Sunlight PPFD umol/m^2s', 54.054054054);
        static::addUnit($newUnit);
	
        // Sunlight PPFD
        $newUnit = UnitOfMeasure::linearUnitFactory('Sunlight W/m^2', 126.5822785);
        static::addUnit($newUnit);
	
        // CW Fluorescent PPFD
        $newUnit = UnitOfMeasure::linearUnitFactory('CW Fluorescent PPFD umol/m^2s', 60.6060606060606060);
        static::addUnit($newUnit);
	
        // Metal Halide PPFD
        $newUnit = UnitOfMeasure::linearUnitFactory('Metal Halide PPFD umol/m^2s', 70.92198582);
        static::addUnit($newUnit);
	
        // Cool White PFD
        $newUnit = UnitOfMeasure::linearUnitFactory('Cool White LED PFD umol/m^2s', 69.5680033756206);
        static::addUnit($newUnit);
        // 450nm Royal Blue PFD
        $newUnit = UnitOfMeasure::linearUnitFactory('450 nm Royal Blue LED PFD umol/m^2s', 12.0604440067588);
        static::addUnit($newUnit);
        // 550nm Green PFD
        $newUnit = UnitOfMeasure::linearUnitFactory('550 nm Green LED PFD umol/m^2s', 108.001535735581);
        static::addUnit($newUnit);
        // 620nm Red PFD
        $newUnit = UnitOfMeasure::linearUnitFactory('620 nm Red LED PFD umol/m^2s', 36.1214533060928);
        static::addUnit($newUnit);
    }
}
