<html>
<head>
<title>Oxman Capsule Corp</title>
<style type="text/css">

:root {
--generalbg: #000000;
--tilebg: #262626;
--grid: #676767;
--text: #ffffff;
--alarmbg: #ff0000;
}

@font-face {
font-family: 'NHG-Display-Light';
src: url('fonts/NeueHaasDisplayLight.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Thin';
src: url('fonts/NeueHaasDisplayThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Extra-Thin';
src: url('fonts/NeueHaasDisplayXThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Extra-Extra-Thin';
src: url('fonts/NeueHaasDisplayXXThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Roman';
src: url('fonts/NeueHaasDisplayRoman.ttf') format('truetype');
}


.label {
font-family: "NHG-Display-Roman";
font-weight: roman;
font-size: 1.558823529412vh;
position: absolute;
z-index:1;
top: 1.031349361735vh;
left: 0.931349361735vh;
}
.time-label {
font-family: "NHG-Display-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
vertical-align:top;
position:relative;
top:1.5vh;
}
.graph-label {
font-family: "NHG-Display-Extra-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
vertical-align:top;
position:relative;
}

.primary {
font-family: "NHG-Display-Extra-Thin";
font-weight: lighter;
font-size: 6.852941176471vh;
float: right;
}

body {
background-color:var(--generalbg);
color:var(--text);
font-family: "NHG-Display-Light";
}
.table{
display:grid;
grid-template-columns: 50% 50%;
width:100%;
height:100%;
}
.cell{
display:table-cell;
position:relative;
}
.graph-cell{
display:table-cell;
grid-row:span 6;
background-color:var(--tilebg);
vertical-align:center;
margin:0.665674680867vh;
}
.header-cell {
font-family: "NHG-Display-Extra-Thin";
font-weight: thin;
font-size: 10.652941176471vh;
display:table-cell;
height:24.9252438307274860vh;
}
.footer-cell {
display:table-cell;
height: 2.84436401240951396vh;
font-family: "NHG-Display-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
text-align:right;
vertical-align:middle;
margin-top:1.3vh;
}
.tile{
background-color: var(--tilebg);
margin: 0.965674680867vh;
padding: 0.231349361735vh;k
}
.alarm{
background-color: var(--alarmbg);
margin: 0.965674680867vh;
padding: 0.231349361735vh;k
}

</style>
<!--<meta http-equiv="refresh" content="5">-->
</head>
<body>
<?php
$ip="216.51.189.91";
$ip="10.2.0.5"; //For testing, comment out.
$ch=curl_init();
curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=Real_Time_Hour&Tag=Real_Time_Minute&Tag=PV_1&Tag=CM_SP_1_Manual&Tag=PV_2&Tag=CM_SP_2_Manual&Tag=PV_3&Tag=CM_SP_3_Manual&Tag=CM_NON_RAMPING_MODE&Tag=Programmed_Lights&Tag=Programmed_Lights_On&Tag=Limit2_PV");
$xml=curl_exec($ch);
$simplexml = new SimpleXMLElement($xml);
foreach($simplexml as $element => $value) {
    $$element = (string)$value;
}
curl_setopt($ch,CURLOPT_URL,$ip."/alarm_status.xml?Cmd=read&Item=menu");
$xml=curl_exec($ch);
$simplexml = new SimpleXMLElement($xml);
foreach($simplexml as $element => $value) {
    $$element = (string)$value;
}
curl_close($ch);


//You got to make da graph-ba, make da graph-ba. nananananananaaaaa, make the graph-ba
$width = isset($_GET['width']) ? $_GET['width'] : 1920;
$height = isset($_GET['height']) ? $_GET['height'] : 1080;
$imagewidth = floatval($width)*(25.4/52.3);
$imageheight = floatval($height)*(17/22);
include_once("lib/classes/pChart/pColor.php"); 
include_once("lib/classes/pChart/pDraw.php"); 
include_once("lib/classes/pChart/pCharts.php");
use pChart\pColor;
use pChart\pDraw;
use pChart\pCharts;
$PVs=array(23.9,24,23.9,24.1,24);
$SPs=array(24,24,24,24,20);
$time=array("12PM","1PM","2PM","3PM","4PM");
    /* Create your dataset object */ 
    $myPicture= new pDraw($imagewidth,$imageheight); 
    /* Add data in your dataset */ 
    $myPicture->myData->addPoints($PVs,"Temp PVs");
    $myPicture->myData->addPoints($SPs,"Temp SPs");
    $myPicture->myData->addPoints($time,"Times");
    $myPicture->myData->setAbscissa("Times");
    //$myPicture->myData->setXAxisDisplay(AXIS_FORMAT_TIME);
    $myPicture->myData->setPalette("Temp PVs",new pColor(255,255,255,255));//(255,0,0,255));//logger temp is red.
    $myPicture->myData->setPalette("Temp SPs",new pColor(80,80,80,255));//(0,255,0,255));//logger RH is green.
    /*
    $seriesSettings=array("R"=>230,"G"=>0,"B"=>0,'Alpha'=>80);
    $myPicture->myData->setPalette("Ambient Temp",$seriesSettings);
    $seriesSettings=array("R"=>0,"G"=>0,"B"=>230,'Alpha'=>80);
    $myPicture->myData->setPalette("Ambient RH",$seriesSettings);
     */
    /* Create a pChart object and associate your dataset */ 
    //$myPicture = new pImage(1024,520,$myData);
    /* Choose a nice font */
    $myPicture->setFontProperties(array("FontName"=>"lib/fonts/CenturyGothic.ttf","FontSize"=>11));
    /* Define the boundaries of the graph area */
    $myPicture->setGraphArea(0,0,$imagewidth,$imageheight);
    $myPicture ->drawFilledRectangle(0,0,$imagewidth,$imageheight,["Color"=>new pColor(0,0,0,100)]);
    /* Draw guide lines */
    /*
    for($y=50;$y<950;$y=$y+5) {
	    $myPicture->drawLine(50,$y,950,$y,["Color"=>new pColor(0,200,200,40),"Ticks"=>0]);
    };
    for($y=50;$y<950;$y=$y+39) {
	    $myPicture->drawLine($y,50,$y,950,["Color"=>new pColor(0,200,200,40),"Ticks"=>0]);
    };
     */
    /*Set axis boundaries*/
    $axisBoundaries=array(0=>array("Min"=>-15,"Max"=>100));
    /* Draw the scale, keep everything automatic */ 
	//echo $n;
    //$labelSkip=intval($n/30);
    $labelSkip=1;
    $labelSkip=0;
    $myPicture->drawScale(array("Mode"=>SCALE_MODE_MANUAL,"GridTicks"=>0,"ManualScale"=>$axisBoundaries,"GridR"=>40,"GridG"=>40,"GridB"=>40,"LabelSkip"=>$labelSkip,"LabelRotation"=>0,"DrawYLines"=>ALL,"CycleBackground"=>TRUE,"BackgroundColor1"=>new pColor(20,20,20,255),"BackgroundColor2"=>new pColor(20,20,20,255),"AxisColor"=>new pColor(255,255,255,255)));
    /* Draw the scale, keep everything automatic */ 
    $pCharts= new pCharts($myPicture);
    $pCharts->drawSplineChart();
    /* Render the picture (choose the best way) */
    $myPicture->Render("temp.png");



$str="";
$str.="<div class='table'>";
$str.="<div class='header-cell'>Capsule 1</div>";
$Real_Time_Minute=str_pad($Real_Time_Minute,2,'0',STR_PAD_LEFT); //Catch if single digit.
$str.="<div class='cell'><span class='primary'><span class='time-label'>TIME&nbsp;&nbsp;&nbsp;&nbsp;</span>".$Real_Time_Hour.":".$Real_Time_Minute."</span></div>";
$str.="";
$str.="<div class='cell'><!--This space intentionally left blank--></div>";
$str.="<div class='cell'><span class='graph-label'>TEMP LAST SIX HOURS</span><span class='graph-label' style='float:right;'>HUM LAST SIX HOURS</span></div>";
$str.="";
$CM_NON_RAMPING_MODE=strtoupper($CM_NON_RAMPING_MODE); //For aesthetics.
$str.="<div class='cell tile'><span class='label'>MODE</span><span class='primary'>".$CM_NON_RAMPING_MODE."</span></div>";
$str.="<div class='graph-cell'><div class='image-container'><img src=''></div></div>";
if($Programmed_Lights==0) {
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>OFF</span></div>";
} else if($Programmed_Lights==$Programmed_Lights_On) {
	//Just in case we need some differentiation in light levels of some kind in the future...
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>ON</span></div>";
} else {
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>ON</span></div>";
};
if($Temp_Soft_High=="Off"||$Temp_Soft_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>".$PV_1."</span></div>";
} else {
$str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>".$PV_1."</span></div>";
};
if($Temp_Limit2_High=="Off"||$Temp_Limit2_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>LIMIT 2</span><span class='primary'>".$Limit2_PV."</span></div>";
} else {
$str.="<div class='cell alarm'><span class='label'>LIMIT 2</span><span class='primary'>".$Limit2_PV."</span></div>";
};
if($RH_Soft_High=="Off"||$RH_Soft_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>".$PV_2."</span></div>";
} else {
$str.="<div class='cell alarm'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>".$PV_2."</span></div>";
};
if($Aux_Soft_High=="Off"||$Aux_Soft_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."PPM</span><span class='primary'>".$PV_3."PPM</span></div>";
} else {
$str.="<div class='cell alarm'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."PPM</span><span class='primary'>".$PV_3."PPM</span></div>";
};
$str.="<div class='footer-cell'><!--This space intentionally left blank--></div>";
$str.="<div class='footer-cell'>TEMPERATURE ----- RELATIVE HUMIDITY --  --  --  --</div>";
$str.="</div>";
echo $str;
?>
</body>
</html>
