<html>
<head>
<title>Oxman Capsule Corp</title>
<style type="text/css">

:root {
--generalbg: #000000;
--tilebg: #262626;
--grid: #676767;
--text: #ffffff;
--alarmbg: #ff0000;
}

@font-face {
font-family: 'NHG-Display-Light';
src: url('fonts/NeueHaasDisplayLight.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Thin';
src: url('fonts/NeueHaasDisplayThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Extra-Thin';
src: url('fonts/NeueHaasDisplayXThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Extra-Extra-Thin';
src: url('fonts/NeueHaasDisplayXXThin.ttf') format('truetype');
}
@font-face {
font-family: 'NHG-Display-Roman';
src: url('fonts/NeueHaasDisplayRoman.ttf') format('truetype');
}


.label {
font-family: "NHG-Display-Roman";
font-weight: roman;
font-size: 1.558823529412vh;
position: absolute;
z-index:1;
top: 1.031349361735vh;
left: 0.931349361735vh;
}
.time-label {
font-family: "NHG-Display-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
vertical-align:top;
position:relative;
top:1.5vh;
}
.graph-label {
font-family: "NHG-Display-Extra-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
vertical-align:top;
position:relative;
}

.primary {
font-family: "NHG-Display-Extra-Thin";
font-weight: lighter;
font-size: 6.852941176471vh;
float: right;
}

body {
background-color:var(--generalbg);
color:var(--text);
font-family: "NHG-Display-Light";
}
img {
width:100%;
height:100%;
}
.table{
display:grid;
grid-template-columns: 50% 50%;
width:100%;
height:100%;
}
.cell{
display:table-cell;
position:relative;
}
.graph-cell{
display:table-cell;
grid-row:span 6;
background-color:var(--tilebg);
vertical-align:center;
margin:0.665674680867vh;
}
.header-cell {
font-family: "NHG-Display-Extra-Thin";
font-weight: thin;
font-size: 10.652941176471vh;
display:table-cell;
height:24.9252438307274860vh;
margin-left: 1.931349361734vh;
}
.footer-cell {
display:table-cell;
height: 2.84436401240951396vh;
font-family: "NHG-Display-Thin";
font-weight: roman;
font-size: 1.558823529412vh;
text-align:right;
vertical-align:middle;
margin-top:1.3vh;
margin-right:0.665674680867vh;
}
.tile{
background-color: var(--tilebg);
margin: 0.965674680867vh;
padding: 0.231349361735vh;
margin-top: 0.965674680867vh;
margin-bottom: 0.965674680867vh;
margin-left: 1.931349361734vh;
margin-right: 1.931349361734vh;
padding-top: 0.235053065438703703703vh;
padding-bottom: 0.231349361735vh;
padding-left: 0.231349361735vh;
padding-right: 0.581349361735vh;
}
.alarm{
background-color: var(--alarmbg);
margin: 0.965674680867vh;
padding: 0.231349361735vh;
margin-top: 0.965674680867vh;
margin-bottom: 0.965674680867vh;
margin-left: 1.931349361734vh;
margin-right: 1.931349361734vh;
padding-top: 0.235053065438703703703vh;
padding-bottom: 0.231349361735vh;
padding-left: 0.231349361735vh;
padding-right: 0.581349361735vh;
}

</style>
<!--<meta http-equiv="refresh" content="5">-->
</head>
<body>
<?php
//$ip="216.51.189.91";
//$ip="10.2.0.5"; //For testing, comment out.
$ip="192.168.2.2";
$ch=curl_init();
curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=Real_Time_Hour&Tag=Real_Time_Minute&Tag=PV_1&Tag=CM_SP_1_Manual&Tag=PV_2&Tag=CM_SP_2_Manual&Tag=PV_3&Tag=CM_SP_3_Manual&Tag=CM_NON_RAMPING_MODE&Tag=Programmed_Lights&Tag=Programmed_Lights_On&Tag=Limit2_PV");
$xml=curl_exec($ch);
$simplexml = new SimpleXMLElement($xml);
foreach($simplexml as $element => $value) {
    $$element = (string)$value;
}
curl_setopt($ch,CURLOPT_URL,$ip."/alarm_status.xml?Cmd=read&Item=menu");
$xml=curl_exec($ch);
$simplexml = new SimpleXMLElement($xml);
foreach($simplexml as $element => $value) {
    $$element = (string)$value;
}



//You got to make da graph-ba, make da graph-ba. nananananananaaaaa, make the graph-ba
$width = isset($_GET['width']) ? $_GET['width'] : 800;//Assuming total screen width/height
$height = isset($_GET['height']) ? $_GET['height'] : 500;
$width=(441.031/918)*$width;
$height=(646.094/1080)*$height;
$imagewidth = floatval($width)*(25.4/52.3);
$imageheight = floatval($height)*(17/22);
require_once("vendor/autoload.php");

use CpChart\Data;
use CpChart\Image;

// Add your array of time data here--timestamps ahoy!

//$data=str_getcsv(file_get_contents('../0PV.txt'));
$data=file_get_contents('../0PV.txt');
preg_match_all('/\{x:\s*([^,\s]+),\s*y:\s*([^,\s]+),\}/',$data,$matches,PREG_PATTERN_ORDER);
$timeDataArray=$matches[1];
$data1=$matches[2];
$data=file_get_contents('../1PV.txt');
preg_match_all('/\{x:\s*([^,\s]+),\s*y:\s*([^,\s]+),\}/',$data,$matches,PREG_PATTERN_ORDER);
$timeData=$matches[1];
$data2=$matches[2];
$timeData=array_slice($timeData,count($timeData)-360);
$data1=array_slice($data1,count($data1)-360);
$data2=array_slice($data2,count($data2)-360);

//data cleanup
for($i=0;$i<360;$i++) {
	//$timeData[$i]=1230768000+$i*60;
	$data1[$i]=$data1[$i];
	if($i%20>10) {
		$data2[$i]=VOID;
	} else {
		$data2[$i]=$data2[$i]+60;
	};
};
//var_dump($data1);
//var_dump($data2);

//The +5 map is combined with the YAxisLabelOffset below to keep the labels from overlapping
foreach($data1 as $key=>$value) {
	if($value==VOID) {
		$data1[$key]=VOID;
	} else {
		$data1[$key]=$value+5;
	};
};
foreach($data2 as $key=>$value) {
	if($value==VOID) {
		$data2[$key]=VOID;
	} else {
		$data2[$key]=$value+5;
	};
};
//Should these data arrays have VOIDs in them?


//var_dump($timeData);
//var_dump($data1);
$chartData = new Data();
$chartData->addPoints($data1, "Series1");
$chartData->addPoints($data2, "Series2");
$chartData->addPoints($timeData, "Abscissa"); // time data
$chartData->setSerieDescription("Abscissa", "Time");
$chartData->setAbscissa("Abscissa");
$chartData->setSerieOnAxis("Series1",0);
$chartData->setSerieOnAxis("Series2",1);
$chartData->setSerieWeight("Series1",1);
$chartData->setSerieWeight("Series2",1);
$chartData->setAxisPosition(0,AXIS_POSITION_LEFT);
$chartData->setAxisPosition(1,AXIS_POSITION_RIGHT);
$axisBoundaries=array(0=>array("Min"=>0,"Max"=>60),1=>array("Min"=>30,"Max"=>90));
$chartData->setXAxisDisplay(AXIS_FORMAT_TIME,"H:i");
$chartData->setSerieTicks("Series2",5);
$chartData->setPalette("Series1",array("R"=>255,"G"=>255,"B"=>255,"Alpha"=>100));
$chartData->setPalette("Series2",array("R"=>255,"G"=>255,"B"=>255,"Alpha"=>100));

$chartData->setAxisName(0, "Temperature");
$chartData->setAxisName(1, "RH");

$image = new Image($width, $height, $chartData);
//$image->setGraphArea(50, 50, 450, 250);
$image->setGraphArea(0, 0, $width, $height);
$image->Antialias=TRUE;
$image->drawFilledRectangle(0,0,$width,$height,array("R"=>38,"G"=>38,"B"=>38));
$image->setFontProperties(array("FontSize"=>ceil((32/118)*$height/12),"R"=>255,"G"=>255,"B"=>255));

$image->drawScale(array(
	"Mode"=>SCALE_MODE_MANUAL,
	"ManualScale"=>$axisBoundaries,
	"Factors"=>array(5),
	"GridR"=>103,
	"GridG"=>103,
	"GridB"=>103,
	"GridAlpha"=>100,
	"SkippedAxisAlpha"=>0,//Otherwise you get dashed line bs
	"TickAlpha"=>0,//To hide small ticks on RHS axis
	"GridTicks"=>0,
	"LabelSkip"=>59,//Will need to change this according to data...or maybe data should have VOIDs?
	"SkippedInnerTickWidth"=>0,
	"YAxisLabelOffset"=>ceil($height/12)//Homebrewed into the Draw class so I could stop the y-axis labels from overlaying on top of the time labels
));

$image->setShadow(FALSE);

$image->drawLineChart(array(
    "DisplayValues" => false,
    "DisplayColor" => DISPLAY_MANUAL,
    "R" => 255,
    "G" => 255,
    "B" => 255,
    "Surrounding" => 10,
    "LabelR"=>255,
    "LabelG"=>255,
    "LabelB"=>255,
    "LabelAlpha"=>100
));

$image->render("Temp.png");



$str="";
$str.="<div class='table'>";
$str.="<div class='header-cell'>Capsule 1</div>";
$Real_Time_Minute=str_pad($Real_Time_Minute,2,'0',STR_PAD_LEFT); //Catch if single digit.
$str.="<div class='cell'><span class='primary' style='margin-right:0.665674680867vh'>".$Real_Time_Hour.":".$Real_Time_Minute."</span></div>";
$str.="";
$str.="<div class='cell'><!--This space intentionally left blank--></div>";
//$str.="<div class='cell'><span class='graph-label' style='margin-left:0.665674680867vh'>TEMP LAST 6 HOURS</span><span class='graph-label' style='margin-right:0.665674680867vh;float:right;'>HUM LAST 6 HOURS</span></div>";
$str.="<div class='cell'><span class='graph-label' style='margin-left:0.665674680867vh;text-decoration:underline;text-underline-offset:5px;'>TEMPERATURE &deg;C</span><span class='graph-label' style='margin-right:0.665674680867vh;float:right;text-decoration:underline;text-decoration-style:dashed;text-underline-offset:5px;'>HUMIDITY %RH</span></div>";
$str.="";
$CM_NON_RAMPING_MODE=strtoupper($CM_NON_RAMPING_MODE); //For aesthetics.
$str.="<div class='cell tile'><span class='label'>MODE</span><span class='primary'>".$CM_NON_RAMPING_MODE."</span></div>";
$str.="<div class='graph-cell'><div class='image-container'><img src='Temp.png'></div></div>";
if($Programmed_Lights==0) {
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>OFF</span></div>";
} else if($Programmed_Lights==$Programmed_Lights_On) {
	//Just in case we need some differentiation in light levels of some kind in the future...
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>ON</span></div>";
} else {
	$str.="<div class='cell tile'><span class='label'>LIGHTS</span><span class='primary'>ON</span></div>";
};
  $PV_1=str_replace(' ','&deg;',$PV_1);
if($Temp_Soft_High=="Off"&&$Temp_Soft_Low=="Off"&&$Temp_Safety_High=="Off"&&$Temp_Safety_Low=="Off") {
  $str.="<div class='cell tile'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>".$PV_1."</span></div>";
} else {
  curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=ALM_Temp_Soft_Alarm_High&Tag=ALM_Temp_Soft_Alarm_Low&Tag=ALM_Temp_Safety_Alarm_High&Tag=ALM_Temp_Safety_Alarm_Low");
  $xml=curl_exec($ch);
  $simplexml = new SimpleXMLElement($xml);
  foreach($simplexml as $element => $value) {
      $$element = (string)$value;
  }
  if(floatval($PV_1)>min(floatval($ALM_Temp_Soft_Alarm_High),floatval($ALM_Temp_Safety_Alarm_High))) {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>HIGH</span></div>";
  } else if(floatval($PV_1)<max(floatval($ALM_Temp_Soft_Alarm_Low),floatval($ALM_Temp_Safety_Alarm_Low))) {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>LOW</span></div>";
  } else {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>".$PV_1."</span></div>";
  };
};
  $Limit2_PV=str_replace(' ','&deg;',$Limit2_PV);
if($Temp_Limit2_High=="Off"&&$Temp_Limit2_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>LIMIT 2</span><span class='primary'>".$Limit2_PV."</span></div>";
} else {
  curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=ALM_Temp_Limit2_Alarm_High&Tag=ALM_Temp_Limit2_Alarm_Low");
  $xml=curl_exec($ch);
  $simplexml = new SimpleXMLElement($xml);
  foreach($simplexml as $element => $value) {
      $$element = (string)$value;
  }
  if(floatval($Limit2_PV)>floatval($ALM_Temp_Limit2_Alarm_High)) {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>HIGH</span></div>";
  } else if(floatval($Limit2_PV)<floatval($ALM_Temp_Limit2_Alarm_low)) {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>LOW</span></div>";
  } else {
    $str.="<div class='cell alarm'><span class='label'>TEMPERATURE<BR>SP:".$CM_SP_1_Manual."</span><span class='primary'>".$Limit2_PV."</span></div>";
  };
};
if($RH_Soft_High=="Off"&&$RH_Soft_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>".$PV_2."</span></div>";
} else {
  curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=ALM_Rh_Alarm_High&Tag=ALM_Rh_Alarm_Low");
  $xml=curl_exec($ch);
  $simplexml = new SimpleXMLElement($xml);
  foreach($simplexml as $element => $value) {
      $$element = (string)$value;
  }
  if(floatval($PV_2)>floatval($ALM_Rh_Alarm_High)) {
    $str.="<div class='cell alarm'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>HIGH</span></div>";
  } else if(floatval($PV_2)<floatval($ALM_Rh_Alarm_Low)) {
    $str.="<div class='cell alarm'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>LOW</span></div>";
  } else {
    $str.="<div class='cell alarm'><span class='label'>RELATIVE HUMIDITY<BR>SP:".$CM_SP_2_Manual."</span><span class='primary'>".$PV_2."</span></div>";
  };
};
if($Aux_Soft_High=="Off"&&$Aux_Soft_Low=="Off") {
$str.="<div class='cell tile'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."PPM</span><span class='primary'>".$PV_3."PPM</span></div>";
} else {
  curl_setopt($ch,CURLOPT_URL,$ip."/read_data.xml?Cmd=read&Tag=ALM_Aux_Soft_Alarm_High&Tag=ALM_Aux_Soft_Alarm_Low");
  $xml=curl_exec($ch);
  $simplexml = new SimpleXMLElement($xml);
  foreach($simplexml as $element => $value) {
      $$element = (string)$value;
  }
  if(floatval($PV_3)>floatval($ALM_Aux_Soft_Alarm_High)) {
    $str.="<div class='cell alarm'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."</span><span class='primary'>HIGH</span></div>";
  } else if(floatval($PV_3)<floatval($ALM_Aux_Soft_Alarm_Low)) {
    $str.="<div class='cell alarm'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."</span><span class='primary'>LOW</span></div>";
  } else {
    $str.="<div class='cell alarm'><span class='label'>CO2<BR>SP:".$CM_SP_3_Manual."</span><span class='primary'>".$PV_3."</span></div>";
  };
};
$str.="<div class='footer-cell'><!--This space intentionally left blank--></div>";
$str.="<div class='footer-cell'><!--This space intentionally left blank--></div>";
//$str.="<div class='footer-cell'>TEMPERATURE ----- RELATIVE HUMIDITY --  --  --  --</div>";
$str.="</div>";
echo $str;
curl_close($ch);
?>
</body>
</html>




