<?php
include 'credentialCheck.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<title>Intellus Settings</title>
		<link rel="stylesheet" href="jquery-ui.css">
		<link rel="stylesheet" href="normalize.css">
		<style>
			i {
				color:black;
			}
			body {
				font-family: 'Roboto',sans serif;
				font-weight: 400;
				font-style: normal;
				color: #6F6D6D;
				margin-left:10vw!important;
			}
			input {
				width:4em;
				font-family: 'Roboto',sans serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.save {
                width:12em;
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			table {
				table-layout:fixed;
				display:inline-block;
			}
			td {
				width:10vw;
				color:#7f7e7e;
				font-family: 'Roboto',sans serif;
			}
			.demo {
				width: 80vw;
				border-right: solid #ffffff 5vw;
				border-left: solid #ffffff 5vw;
			}
			.demo2 {
				width: 80vw;
				border-right: solid #f7f7f7 5vw;
				border-left: solid #f7f7f7 5vw;
			}
			.tdInput {
				width: fit-content;
			}
			.tdLast {
				width:60vw;
			}
			.textField {
				border-radius: 4px;
				border-color: #dee7e7;
				box-shadow: 1px 1px 0px #6F6D6D;
			}

			.ui-state-default{
				border:0px!important;
			}
			.ui-slider-horizontal {
				height:1px;
				background-color:#425d94;
			}
			.ui-widget.ui-widget-content {
				border: 5px solid #c5c5c5;
			}
			.ui-slider .ui-slider-handle {
				margin-left: 1px;
			}
			.glider-slide {
				margin:10px;
			}
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-ui.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="glider.js"></script>
		<script src="circle-progress.js"></script>
		<script src="jquery.modal.min.js"></script>
		<link rel="stylesheet"  type="text/css" href="jquery.modal.min.css">
		<link rel="stylesheet"  type="text/css" href="glider.css">
		<link rel="stylesheet"  type="text/css" href="toggle-switch.css">
<style>
#setpoint {
	margin:10px;
}
.ui-slider-horizontal {
	height: 10px;
	background-image: linear-gradient(90deg,#58A8DC,#D53834);
	border-radius: 5px;
}
.ui-slider .ui-slider-handle {
	width:4px;
	height:18px;
	border: 1px solid red!important;
	border-radius: 0px!important;
}
@keyframes pulse {
	0% {box-shadow: 0 0 0px 0px #dee7e7;}
	50% {box-shadow: 0 0 0px 10px #dee7e7;}
	100% {box-shadow: 0 0 0px 0px #dee7e7;}
}
td {
	text-align:center;
}
input[type=number]::-webkit-inner-spin-button,input[type=number]::-webkit-out-spin-button {
	-webkit-appearance: none;
	opacity: 0;
}

input {
	border-width:0px;
	border:none;
	border-bottom: 1px solid #8A8A8A;
	background-color: #F1F2F2;
	margin-left: 1px;
	margin-right: 1px;
	text-align: center;
}
.setpoint {
	color:black;
	font-weight:600;
	font-size:large;
	font-family: Verdana, Arial, sans-serif;
}
.move {
	position: relative;
	top: 5px;
}
.card {
	border: 2px solid #3878B9;
	border-radius: 10px;
	background-color: #F1F2F2;
	margin: 10px;
}
.leftCard {
	border: 2px solid #3878B9;
	border-width: 1px 1px 1px 15px;
	border-radius: 10px;
	background-color: #F1F2F2;
	box-sizing:border-box;
	padding-top: 10px;
	padding-bottom: 10px;
}
.topCard {
	border: 2px solid #3878B9;
	border-width: 15px 1px 1px 1px;
	border-radius: 10px;
	background-color: #F1F2F2;
	box-sizing:border-box;
}
table {
	border-collapse:collapse;
}
div.textShift {
	color: white;
	font-size: 10px;
	font-weight:600;
	font-family: 'Roboto', Arial, sans-serif;
	position: relative;
	top:-14px;
}
td.title {
	color:black;
	font-weight:600;
	font-family: Verdana, Arial, sans-serif;
}
</style>
<?php
include('lhs.php');
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function inputPVs($string) {
	preg_match_all("/PV_[0-9]>[^<]+<\/PV_[0-9]/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],5,-6);
	};
	return $input;
}
function inputSPs($string) {
	preg_match_all("/Manual>[^<]+<\/CM_SP_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],7,-8);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function grabSafeties($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<6;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function grabAlarms($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$i0=2*$i+0;
		$i1=2*$i+1;
		$state=substr($matches[$i0],1,-2);
		if($state!=="Off") {
			$state=substr($matches[$i1],1,-2);
		} else {
			$input[$i]="Off";
		};
	};
	$state=substr($matches[14],1,-2);
	if($state=="Yes") {
		$input[7]="Both";
	} else {
		$input[7]="Off";
	};
	return $input;
}
function grabEnables($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="Yes";
	$input[1]="Yes";
	for($i=0;$i<6;$i++) {
		$i0=2*$i+0;
		$i1=2*$i+1;
		$state=substr($matches[$i0],1,-2);
		$input[$i0+2]=$state;
		$state=substr($matches[$i1],1,-2);
		$input[$i1+2]=$state;
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function outputDim($string) {
	preg_match_all("/Dim>[^<]+<\/EO_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=(float)substr($matches[$i],4,-5);
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO) {
	$str.="<tr><td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$i]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField'></div></td>";
		};
	};
	for($i=0;$i<5;$i++) {
		for($j=0;$j<count($outputCheck[$i]);$j++) {
			$num=$i*10+$j+1;
			if($outputCheck[$i][$j]==1) {
				if(isset($EO[$num])) {
					if($EO[$num]==="ON"||$EO[$num]===100||$EO[$num]==="100") {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON' selected>ON</option><option value='OFF'>OFF</option></select></div></td>";
					} else {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
					};
				} else {
					$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
				};
				$eolist[]=$num;
			} else if($outputCheck[$i][$j]==2) {
				$eolist[]=$num;
				$str.="<td><div class='tdelement'>Dimm % $num<input name='EO{$num}[]' type='number' value='".$EO[$num]."' min='0' max='100' step='0.1' class='forceRight textField'></div></td>";
			};
		};
	};
	$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

?>

	</head>
	<body>
<?php
echo LHS('settings'); //TODO:  Grab from server URI.
//echo LHS2('input0',$inputTags,$inputNames); //TODO:  Grab from server URI.

//TODO:  Low v. High soft alarms?
//TODO:  Save button
function writeSlider($str,$name,$unit,$setpoints,$low,$high,$channel,$softAlarm,$channelA,$channelB) {
	$setpoint=$setpoints[0];
	$lowSoft=$setpoints[1];
	$highSoft=$setpoints[2];
	if($channel==1) {
		$lowLimit1=$setpoints[3];
		$highLimit1=$setpoints[4];
		$lowLimit2=$setpoints[5];
		$highLimit2=$setpoints[6];
		$deviation=$setpoints[7];
	};
	$str.="<div>";
	$str.="<table class='card'>";
	$str.="<tr>";
	$str.="<td class='title'><BR>$name ($unit)<BR></td>";
	$str.="<td><BR><input type='number' step='0.1' id='setpointValue$channel' name='setpointValue$channel' class='setpoint' value='$setpoint'><BR></td></tr><tr><td colspan='2'><BR><div id='setpoint$channel'></div><BR></td>";
	$str.="</tr>";
	//Enable switches
	if($channel>1) {
		$str.="<tr>";
		if($channelA=="Yes") {
			$str.="<td><div class='topCard'><div class='textShift'>CHANNEL A</div><label class='switch-light switch-material'><input type='checkbox' id='enableA{$channel}' name='enableA{$channel}' checked/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON</div></td>";
		} else {
			$str.="<td><div class='topCard'><div class='textShift'>CHANNEL A</div><label class='switch-light switch-material'><input type='checkbox' id='enableA{$channel}' name='enableA{$channel}'/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON</div></td>";
		};
		if($channelB=="Yes") {
			$str.="<td><div class='topCard'><div class='textShift'>CHANNEL B</div><label class='switch-light switch-material'><input type='checkbox' id='enableB{$channel}' name='enableB{$channel}' checked/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON</div></td>";
		} else {
			$str.="<td><div class='topCard'><div class='textShift'>CHANNEL B</div><label class='switch-light switch-material'><input type='checkbox' id='enableB{$channel}' name='enableB{$channel}'/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON</div></td>";
		};
		$str.="</tr>";
	};
	//Alarms
	$str.="<tr>";
	if($channel>1) {
		if($softAlarm=="Off") {
			$str.="<td></td><td><input type='hidden' value='19' id='lowSoftValue$channel' name='lowSoftValue$channel'><input type='hidden' value='20' id='highSoftValue$channel' name='highSoftValue$channel'></td>";
		} else {
			$str.="<td></td><td><div class='topCard'><div class='textShift'>SOFT ALARM</div><input type='number' step='0.1' id='lowSoftValue$channel' name='lowSoftValue$channel'><input type='number' step='0.1' id='highSoftValue$channel' name='highSoftValue$channel'><BR><BR><div id='soft$channel'></div><BR></div></td>";
		};
	} else{
		$str.="<td><div class='topCard'><div class='textShift'>LIMIT 1 ALARM</div><input type='number' step='0.1' id='lowLimit1Value$channel' name='lowLimit1Value$channel'><input type='number' step='0.1' id='highLimit1Value$channel' name='highLimit1Value$channel'><BR><BR><div id='limit1$channel'></div><BR></div></td>";
		$str.="<td><div class='topCard'><div class='textShift'>LIMIT 2 ALARM</div><input type='number' step='0.1' id='lowLimit2Value$channel' name='lowLimit2Value$channel'><input type='number' step='0.1' id='highLimit2Value$channel' name='highLimit2Value$channel'><BR><BR><div id='limit2$channel'></div><BR></div></td>";
		$str.="</tr>";
		$str.="<tr>";
		if($softAlarm=="Off") {
			$str.="<td><input type='hidden' id='lowSoftValue$channel' name='lowSoftValue$channel'><input type='hidden' id='highSoftValue$channel' name='highSoftValue$channel'></td>";
		} else {
			$str.="<td><div class='topCard'><div class='textShift'>SOFT ALARM</div><input type='number' step='0.1' id='lowSoftValue$channel' name='lowSoftValue$channel'><input type='number' step='0.1' id='highSoftValue$channel' name='highSoftValue$channel'><BR><BR><div id='soft$channel'></div><BR></div></td>";
		};
		if($deviation=="Off") {
			$str.="<td><input type='hidden' id='deviationValue$channel' name='deviationValue$channel' value='5'></td>";
		} else {
			$str.="<td><div class='topCard'><div class='textShift'>DEVIATION</div><input type='number' step='0.1' id='deviationValue$channel' name='deviationValue$channel'><BR><BR><div id='deviation$channel'></div><BR></div></td>";
		};
	};
	$str.="</tr>";
	$str.="</table>";
	$str.="</div>";
	$str.="<script>";
	$str.="var setpoint$channel=$setpoint;";
	$str.="var minTemp$channel=$low;";
	$str.="var maxTemp$channel=$high;";
	if($softAlarm=="Off") {
		$str.="var lowSoft$channel=19;";
		$str.="var highSoft$channel=20;";
	} else {
		$str.="var lowSoft$channel=$lowSoft;";
		$str.="var highSoft$channel=$highSoft;";
	};
	if($channel==1) {
		if($deviation=="Off") {
			$str.="var deviation=5;";
		} else {
			$str.="var deviation=$deviation;";
		};
		$str.="var lowLimit1=$lowLimit1;";
		$str.="var highLimit1=$highLimit1;";
		$str.="var lowLimit2=$lowLimit2;";
		$str.="var highLimit2=$highLimit2;";
	};
	$str.="document.getElementById('setpointValue$channel').value=setpoint$channel;";
	$str.="document.getElementById('lowSoftValue$channel').value=lowSoft$channel;";
	$str.="document.getElementById('highSoftValue$channel').value=highSoft$channel;";
	if($channel==1) {
		$str.="document.getElementById('deviationValue$channel').value=deviation;";
		$str.="document.getElementById('lowLimit1Value$channel').value=lowLimit1;";
		$str.="document.getElementById('highLimit1Value$channel').value=highLimit1;";
		$str.="document.getElementById('lowLimit2Value$channel').value=lowLimit2;";
		$str.="document.getElementById('highLimit2Value$channel').value=highLimit2;";
	};
	$str.="$( \"#setpoint$channel\" ).slider({";
	$str.="	min: 0,";
	$str.="	max: 100,";
	$str.="	step: 0.1,";
	$str.="	values: [(setpoint$channel-minTemp$channel)*100/(maxTemp$channel-minTemp$channel)";
	$str.="	],";
	$str.="	slide: function(event,ui) {";
	$str.="		document.getElementById(\"setpointValue$channel\").value=(ui.values[0]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
	$str.="	}";
	$str.="});";
	$str.="$( \"#setpointValue$channel\" ).change(function() {";
	$str.="	$(\"#setpoint$channel\").slider(\"option\",\"values\",[100*($(\"#setpointValue$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
	$str.="	]);";
	$str.="});";
	$str.="$( \"#soft$channel\" ).slider({";
	$str.="	min: 0,";
	$str.="	max: 100,";
	$str.="	step: 0.1,";
	$str.="	values: [(lowSoft$channel-minTemp$channel)*100/(maxTemp$channel-minTemp$channel),(highSoft$channel-minTemp$channel)*100/(maxTemp$channel-minTemp$channel)";
	$str.="	],";
	$str.="	slide: function(event,ui) {";
	$str.="		document.getElementById(\"lowSoftValue$channel\").value=(ui.values[0]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
	$str.="		document.getElementById(\"highSoftValue$channel\").value=(ui.values[1]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
	$str.="	}";
	$str.="});";
	$str.="$( \"#lowSoftValue$channel\" ).change(function() {";
	$str.="	$(\"#soft$channel\").slider(\"option\",\"values\",[100*($(\"#lowSoftValue$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highSoftValue$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
	$str.="	]);";
	$str.="});";
	$str.="$( \"#highSoftValue$channel\" ).change(function() {";
	$str.="	$(\"#soft$channel\").slider(\"option\",\"values\",[100*($(\"#lowSoftValue$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highSoftValue$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
	$str.="	]);";
	$str.="});";
	if($channel==1) {
		$str.="$( \"#deviation$channel\" ).slider({";
		$str.="	min: 0,";
		$str.="	max: 100,";
		$str.="	step: 0.1,";
		$str.="	values: [(deviation-minTemp$channel)*100/(maxTemp$channel-minTemp$channel)";
		$str.="	],";
		$str.="	slide: function(event,ui) {";
		$str.="		document.getElementById(\"deviationValue$channel\").value=(ui.values[0]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
		$str.="	}";
		$str.="});";
		$str.="$( \"#deviationValue$channel\" ).change(function() {";
		$str.="	$(\"#deviation$channel\").slider(\"option\",\"values\",[100*($(\"#deviationValue$channel\").val()-minTemp$channel)/(maxTemp-minTemp$channel)";
		$str.="	]);";
		$str.="});";
		$str.="$( \"#limit1$channel\" ).slider({";
		$str.="	min: 0,";
		$str.="	max: 100,";
		$str.="	step: 0.1,";
		$str.="	values: [(lowLimit1-minTemp$channel)*100/(maxTemp$channel-minTemp$channel),(highLimit1-minTemp$channel)*100/(maxTemp$channel-minTemp$channel)";
		$str.="	],";
		$str.="	slide: function(event,ui) {";
		$str.="		document.getElementById(\"lowLimit1Value$channel\").value=(ui.values[0]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
		$str.="		document.getElementById(\"highLimit1Value$channel\").value=(ui.values[1]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
		$str.="	}";
		$str.="});";
		$str.="$( \"#lowLimit1Value$channel\" ).change(function() {";
		$str.="	$(\"#limit1$channel\").slider(\"option\",\"values\",[100*($(\"#lowLimit1Value\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highLimit1Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
		$str.="	]);";
		$str.="});";
		$str.="$( \"#highLimit1Value$channel\" ).change(function() {";
		$str.="	$(\"#limit1$channel\").slider(\"option\",\"values\",[100*($(\"#lowLimit1Value\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highLimit1Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
		$str.="	]);";
		$str.="});";
		$str.="$( \"#limit2$channel\" ).slider({";
		$str.="	min: 0,";
		$str.="	max: 100,";
		$str.="	step: 0.1,";
		$str.="	values: [(lowLimit2-minTemp$channel)*100/(maxTemp$channel-minTemp$channel),(highLimit2-minTemp$channel)*100/(maxTemp$channel-minTemp$channel)";
		$str.="	],";
		$str.="	slide: function(event,ui) {";
		$str.="		document.getElementById(\"lowLimit2Value$channel\").value=(ui.values[0]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
		$str.="		document.getElementById(\"highLimit2Value$channel\").value=(ui.values[1]*(maxTemp$channel-minTemp$channel)/100+minTemp$channel).toFixed(1);";
		$str.="	}";
		$str.="});";
		$str.="$( \"#lowLimit2Value$channel\" ).change(function() {";
		$str.="	$(\"#limit2$channel\").slider(\"option\",\"values\",[100*($(\"#lowLimit2Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highLimit2Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
		$str.="	]);";
		$str.="});";
		$str.="$( \"#highLimit2Value$channel\" ).change(function() {";
		$str.="	$(\"#limit2$channel\").slider(\"option\",\"values\",[100*($(\"#lowLimit2Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel),100*($(\"#highLimit2Value$channel\").val()-minTemp$channel)/(maxTemp$channel-minTemp$channel)";
		$str.="	]);";
		$str.="});";
	};
	$str.="</script>";
	return $str;
};

//Default values in case of catastrophic error.
$name="TEMP";
$setpoint=25;
$minTemp=0;
$maxTemp=50;
$softAlarmLow=15;
$softAlarmHigh=30;
$safetyAlarmLow=10;
$safetyAlarmHigh=35;
$limit2AlarmLow=9;
$limit2AlarmHigh=36;
//Send user values if available.  Do this BEFORE the read calls!
$ch = curl_init();
if (!empty($_POST)) {
    //Grab user selected values.
    $posted = &$_POST;
    if($posted['save']=='Run Manual Mode') {
	echo "Running Manual Mode.<BR>";
        $tag="http://192.168.1.1/ramping.xml?Cmd=run&Item=ramping_manual";
        curl_setopt($ch, CURLOPT_URL, $tag);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_exec($ch);
    } else {
        //Parse them out for the settable tags, make a giant tag list to send out.
        $tag="";
        foreach($posted as $key=>$value) {
            $channel=preg_replace('/.*[a-zA-Z]([0-9]*)$/','${1}',$key);
            $key=preg_replace('/(.*[a-zA-Z])[0-9]*$/','${1}',$key);
            if($channel=="1") {
                $channelName="Temp";
            } else if($channel=="2") {
                $channelName="Rh";
            } else if($channel=="3") {
                $channelName="Aux";
            } else if($channel=="4") {
                $channelName="Input4";
            } else if($channel=="5") {
                $channelName="Input5";
            } else if($channel=="6") {
                $channelName="Input6";
            } else if($channel=="7") {
                $channelName="Input7";
            };
            //Output # values.
            if($key=="outputExist") {
                if(isset($posted["outputValue$channel"])) {
                    $value=trim($posted["outputValue$channel"]);
                } else {
                    $value=0;
                };
                if($value===0) {
                    $tag.="&EO_{$channel}_On_Off=Off";
                } elseif($value=="on") {
                    $tag.="&EO_{$channel}_On_Off=On";
                };
                $value=round(floatval($value)*100);
                $tag.="&EO_{$channel}_Dim=$value";
            };
            //Input # values.
            $value=round(floatval($value)*1000);
            if($key=="lowLimit1Value") {
                $tag.="&ALM_{$channelName}_Safety_Alarm_Low=$value";
            };
            if($key=="highLimit1Value") {
                $tag.="&ALM_{$channelName}_Safety_Alarm_High=$value";
            };
            if($key=="lowLimit2Value") {
                $tag.="&ALM_{$channelName}_Limit2_Alarm_Low=$value";
            };
            if($key=="highLimit2Value") {
                $tag.="&ALM_{$channelName}_Limit2_Alarm_High=$value";
            };
            if($key=="lowSoftValue") {
                $tag.="&ALM_{$channelName}_Soft_Alarm_Low=$value";
            };
            if($key=="highSoftValue") {
                $tag.="&ALM_{$channelName}_Soft_Alarm_High=$value";
            };
            if($key=="deviation") {
                $tag.="&ALM_Deviation_Alarm_High=$value";
            };
            if($key=="setpointValue") {
                $tag.="&CM_SP_{$channel}_Manual=$value";
                if($channel>1) {
                    //Non number value possibilities.
                    if(isset($posted["enableA$channel"])) {
                            $value="Yes";
                    } else {
                            $value="No";
                    };
                    $tag.="&CLC_Enable_{$channelName}_1=$value";
                    if(isset($posted["enableB$channel"])) {
                            $value="Yes";
                    } else {
                            $value="No";
                    };
                    $tag.="&CLC_Enable_{$channelName}_2=$value";
                };
            };
        };
        $tag="http://192.168.1.1/read_data.xml?Cmd=write$tag";
        curl_setopt($ch, CURLOPT_URL, $tag);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_exec($ch);
    };
};
//GRAB CONTROLLER DATA TO CORRECTLY SET UP Dashboard.
$inputNames="http://192.168.1.1/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputSPs="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CM_SP_1_Manual&Tag=CM_SP_2_Manual&Tag=CM_SP_3_Manual&Tag=CM_SP_4_Manual&Tag=CM_SP_5_Manual&Tag=CM_SP_6_Manual&Tag=CM_SP_7_Manual";
$inputTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$alarmTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=ALM_Temp_Alarm_Enable&Tag=ALM_Temp_Alarm_Sides&Tag=ALM_Rh_Alarm_Enable&Tag=ALM_Rh_Alarm_Sides&Tag=ALM_Aux_Alarm_Enable&Tag=ALM_Aux_Alarm_Sides&Tag=ALM_Input4_Alarm_Enable&Tag=ALM_Input4_Alarm_Sides&Tag=ALM_Input5_Alarm_Enable&Tag=ALM_Input5_Alarm_Sides&Tag=ALM_Input6_Alarm_Enable&Tag=ALM_Input6_Alarm_Sides&Tag=ALM_Input7_Alarm_Enable&Tag=ALM_Input7_Alarm_Sides&Tag=ALM_Deviation_Alarm_Activate";
$enableTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_Enable_Rh_1&Tag=CLC_Enable_Rh_2&Tag=CLC_Enable_Aux_1&Tag=CLC_Enable_Aux_2&Tag=CLC_Enable_In4_1&Tag=CLC_Enable_In4_2&Tag=CLC_Enable_In5_1&Tag=CLC_Enable_In5_2&Tag=CLC_Enable_In6_1&Tag=CLC_Enable_In6_2&Tag=CLC_Enable_In7_1&Tag=CLC_Enable_In7_2";
$highRangeTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_SP_High_1&Tag=CLC_SP_High_2&Tag=CLC_SP_High_3&Tag=CLC_SP_High_4&Tag=CLC_SP_High_5&Tag=CLC_SP_High_6&Tag=CLC_SP_High_7";
$lowRangeTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_SP_Low_1&Tag=CLC_SP_Low_2&Tag=CLC_SP_Low_3&Tag=CLC_SP_Low_4&Tag=CLC_SP_Low_5&Tag=CLC_SP_Low_6&Tag=CLC_SP_Low_7";
$highSoftTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=ALM_Temp_Soft_Alarm_High&Tag=ALM_Rh_Soft_Alarm_High&Tag=ALM_Aux_Soft_Alarm_High&Tag=ALM_Input4_Soft_Alarm_High&Tag=ALM_Input5_Soft_Alarm_High&Tag=ALM_Input6_Soft_Alarm_High&Tag=ALM_Input7_Soft_Alarm_High";
$lowSoftTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=ALM_Temp_Soft_Alarm_Low&Tag=ALM_Rh_Soft_Alarm_Low&Tag=ALM_Aux_Soft_Alarm_Low&Tag=ALM_Input4_Soft_Alarm_Low&Tag=ALM_Input5_Soft_Alarm_Low&Tag=ALM_Input6_Soft_Alarm_Low&Tag=ALM_Input7_Soft_Alarm_Low";
$safetyTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=ALM_Temp_Safety_Alarm_Low&Tag=ALM_Temp_Safety_Alarm_High&Tag=ALM_Temp_Limit2_Alarm_Low&Tag=ALM_Temp_Limit2_Alarm_High&Tag=ALM_Deviation_Alarm_High&Tag=ALM_Deviation_Alarm_Low";
$outputTags[0]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_1&Tag=DO_Function_2&Tag=DO_Function_3&Tag=DO_Function_4&Tag=DO_Function_5&Tag=DO_Function_6&Tag=DO_Function_7&Tag=DO_Function_8&Tag=DO_Function_9&Tag=DO_Function_10";
$outputTags[1]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_11&Tag=DO_Function_12&Tag=DO_Function_13&Tag=DO_Function_14&Tag=DO_Function_15&Tag=DO_Function_16&Tag=DO_Function_17&Tag=DO_Function_18&Tag=DO_Function_19&Tag=DO_Function_20";
$outputTags[2]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_21&Tag=DO_Function_22&Tag=DO_Function_23&Tag=DO_Function_24&Tag=DO_Function_25&Tag=DO_Function_26&Tag=DO_Function_27&Tag=DO_Function_28&Tag=DO_Function_29&Tag=DO_Function_30";
$outputTags[3]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_31&Tag=DO_Function_32&Tag=DO_Function_33&Tag=DO_Function_34&Tag=DO_Function_35&Tag=DO_Function_36&Tag=DO_Function_37&Tag=DO_Function_38&Tag=DO_Function_39&Tag=DO_Function_40";
$outputTags[4]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_41&Tag=DO_Function_42&Tag=DO_Function_43&Tag=DO_Function_44&Tag=DO_Function_45&Tag=DO_Function_46&Tag=DO_Function_47";
$outputLevels[0]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=EO_1_Dim&Tag=EO_2_Dim&Tag=EO_3_Dim&Tag=EO_4_Dim&Tag=EO_5_Dim&Tag=EO_6_Dim&Tag=EO_7_Dim&Tag=EO_8_Dim&Tag=EO_9_Dim&Tag=EO_10_Dim";
$outputLevels[1]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=EO_11_Dim&Tag=EO_12_Dim&Tag=EO_13_Dim&Tag=EO_14_Dim&Tag=EO_15_Dim&Tag=EO_16_Dim&Tag=EO_17_Dim&Tag=EO_18_Dim&Tag=EO_19_Dim&Tag=EO_20_Dim";
$outputLevels[2]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=EO_21_Dim&Tag=EO_22_Dim&Tag=EO_23_Dim&Tag=EO_24_Dim&Tag=EO_25_Dim&Tag=EO_26_Dim&Tag=EO_27_Dim&Tag=EO_28_Dim&Tag=EO_29_Dim&Tag=EO_30_Dim";
$outputLevels[3]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=EO_31_Dim&Tag=EO_32_Dim&Tag=EO_33_Dim&Tag=EO_34_Dim&Tag=EO_35_Dim&Tag=EO_36_Dim&Tag=EO_37_Dim&Tag=EO_38_Dim&Tag=EO_39_Dim&Tag=EO_40_Dim";
$outputLevels[4]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=EO_41_Dim&Tag=EO_42_Dim&Tag=EO_43_Dim&Tag=EO_44_Dim&Tag=EO_45_Dim&Tag=EO_46_Dim&Tag=EO_47_Dim";
$manualCheck="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CM_RAMPING_MODE";
curl_setopt($ch, CURLOPT_URL, $manualCheck);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$manualCheck=preg_match('/Manual/',curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputSPs);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputSPs=inputSPs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$highRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$lowRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highSoftTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$highSoftTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowSoftTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$lowSoftTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $safetyTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$safetyTags=grabSafeties(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $alarmTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$alarmTags=grabAlarms(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $enableTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$enableTags=grabEnables(curl_exec($ch));
//$lowRangeTags[0]=-10;
$lowSoftTags[0]=max($lowRangeTags[0],$lowSoftTags[0]);
$highSoftTags[0]=min($highRangeTags[0],$highSoftTags[0]);
$safetyAlarmLow=max($lowRangeTags[0],$safetyTags[0]);
$safetyAlarmHigh=min($highRangeTags[0],$safetyTags[1]);
$limit2AlarmLow=max($lowRangeTags[0],$safetyTags[2]);
$limit2AlarmHigh=min($highRangeTags[0],$safetyTags[3]);
curl_setopt($ch, CURLOPT_URL, $inputTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputTags=inputCheck(curl_exec($ch));
$str="";
$str.="<form action='settings2.php' method='post' enctype='multipart/form-data'>";
//Writing the input carousel...
$str.="<div class='demo peach'>";
$str.="<div class='glider-contain'>";
$str.="<div class='input-glider'>";
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		$j=$i+1;
		if($i==0) {
			if($alarmTags[7]=="Off") {
				$sps=array($inputSPs[$i],$lowSoftTags[$i],$highSoftTags[$i],$safetyTags[0],$safetyTags[1],$safetyTags[2],$safetyTags[3],"Off");
			} else {
				$sps=array($inputSPs[$i],$lowSoftTags[$i],$highSoftTags[$i],$safetyTags[0],$safetyTags[1],$safetyTags[2],$safetyTags[3],$safetyTags[5]);
			};
		} else {
			$sps=array($inputSPs[$i],$lowSoftTags[$i],$highSoftTags[$i]);
		};
		$str=writeSlider($str,$inputNames[$i],$inputTags[$i],$sps,$lowRangeTags[$i],$highRangeTags[$i],$j,$alarmTags[$i],$enableTags[2*$i+0],$enableTags[2*$i+1]);
	};
};
$str.="</div>";
$str.="  <button aria-label='Previous' type='button' id='input-glider-prev' class='glider-prev peach'>&lt;</button>";
$str.="  <button aria-label='Next' type='button' id='input-glider-next' class='glider-next peach'>&gt;</button>";
$str.="</div>";
$str.="</div>";
//Writing the Outputs...
$str.="<div class='demo peach'>";
$str.="<div class='glider-contain'>";
$str.="<div class='output-glider'>";
//Stop, grab outputs.
$eolist=[];
for($i=0;$i<5;$i++) {
	curl_setopt($ch, CURLOPT_URL, $outputTags[$i]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$outputCheck[$i]=outputCheck(curl_exec($ch));
	curl_setopt($ch, CURLOPT_URL, $outputLevels[$i]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$outputDim[$i]=outputDim(curl_exec($ch));
	for($j=0;$j<count($outputCheck[$i]);$j++) {
		$num=$i*10+$j+1;
		if($outputCheck[$i][$j]) {
			$str.="<div>";
			if($outputCheck[$i][$j]==1||$outputCheck[$i][$j]==2) {
				$str.="<input type='hidden' id='outputExist$num' name='outputExist$num' value='1'>"; //because checkboxes are dumb!
			};
			if($outputCheck[$i][$j]==1) {
				if($outputDim[$i][$j]>0) {
					$str.="<BR>Event ".$num."<label class='switch-light switch-material'><input type='checkbox' id='outputValue$num' name='outputValue$num' checked/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON<BR>";
				} else {
					$str.="<BR>Event ".$num."<label class='switch-light switch-material'><input type='checkbox' id='outputValue$num' name='outputValue$num' /><span><span>Off</span><span>On</span><a></a></span></label><BR>OFF<BR>";
				};
			} elseif($outputCheck[$i][$j]==2) {
				$display=100*$outputDim[$i][$j]/10000; 
				$level=99*$outputDim[$i][$j]/1000000; //I need that as 99 instead of 100 to display a small open sliver in the UI in the case of 100% lights on.  it's a graphical tearing thing.
				$str.="<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Event $num<BR>";
				$str.="<div id='output$num'>&nbsp;&nbsp;<BR><input type='number' step='0.1' id='outputValue$num' name='outputValue$num' value='$display'></div>";
				$str.="<script>";
				$str.="$( \"#output$num\" ).slider({";
				$str.="	min: 0,";
				$str.="	max: 100,";
				$str.="	step: 0.1,";
				$str.="	values: [$display";
				$str.="	],";
				$str.="	slide: function(event,ui) {";
				$str.="		document.getElementById(\"outputValue$num\").value=ui.values[0].toFixed(1);";
				$str.="	}";
				$str.="});";
				$str.="$(\"#outputValue$num\" ).change(function() {";
				$str.="$(\"#output$num\").slider(\"option\",\"values\",[$(\"#outputValue$num\").val()";
				$str.="	]);";
				$str.="});";
				$str.="</script>";
			};
			$str.="</div>";
			$eolist[]=$num;
		};
	};
};
$str.="</div>";
$str.="  <button aria-label='Previous' type='button' id='output-glider-prev' class='glider-prev peach'>&lt;</button>";
$str.="  <button aria-label='Next' type='button' id='output-glider-next' class='glider-next peach'>&gt;</button>";
$str.="</div>";
$str.="</div>";
echo $str;
curl_close($ch);
$str="<script>";
$str.="window.addEventListener('load', function(){";
$str.="  var inputGlider = new Glider(document.querySelector('.input-glider'), {";
$str.="    slidesToScroll: 1,";
$str.="    slidesToShow: 2.5,";
$str.="    draggable: false,";
$str.="    arrows: { prev: '#input-glider-prev', next: '#input-glider-next' }";
$str.="  });";
$str.="  var outputGlider = new Glider(document.querySelector('.output-glider'), {";
$str.="    slidesToScroll: 1,";
$str.="    slidesToShow: 5,";
$str.="    draggable: false,";
$str.="    arrows: { prev: '#output-glider-prev', next: '#output-glider-next' }";
$str.="  });";
$str.="})";
$str.="</script>";
$str.="<input type='submit' name='save' value='Save' class='save'>";
if($manualCheck) {
} else {
$str.="<input type='submit' name='save' value='Run Manual Mode' class='save'>";
};
$str.="</form>";
//Generate Alarms modal.
	$str.="<div id='alarmsModal' class='modal'>";
	$str.="<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' aria-hidden='true' role='img' width='10em' height='10em' preserveAspectRatio='xMidYMid meet' viewBox='0 0 896 1024'><path d='M842 712l-20-25l-19.5-26l-19-29.5l-15-30l-11.5-33l-4-31.5V328q0-67-24-127.5t-64.5-104T567 27T446 1q-84 0-154.5 44T181 164t-40 164v209q0 18-5 36.5t-18 40t-20 32T72 681t-22 28l-18 25.5l-14 22l-10.5 22L5 798l5 21q17 33 83 33h183q0 71 50 121t121 50t121-50t50-121h187q66 0 81-33q4-7 4.5-14.5t0-13.5t-4.5-14.5t-7-14.5t-10.5-16t-12.5-16t-14-18zM447 956q-21 0-40-8.5t-33-22t-22.5-33T343 852h208q0 43-30.5 73.5T447 956zm358-172H81q6-10 24-34q1-2 20-27t25-33t21-32.5t20.5-39.5t11.5-38t6-43V328q0-108 68.5-183.5T446 69q29 0 56 7t50.5 19.5t44 30.5t37 40.5t28 47.5t17.5 54t6 60v209q0 31 9 62.5t27.5 61.5t32 48.5T789 755l4.5 6l4.5 5.5l5 6l4.5 5.5l4.5 6h-7z' fill='#3f796b'/></svg><BR><BR>";
	$str.="<div id='alarmsIndication'>";
	$str.="</div>";
	$str.="</div>";
//End Alarms modal.
echo $str;
?>

<script>
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	};
	});
setInterval(function(){
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	} else {
		$.modal.close();
	};
	});
},60000);
</script>
	</body>
</html>

