<html>
	<head>
		<title>Intellus Settings</title>
		<link rel="stylesheet" href="jquery-ui.css">
		<link rel="stylesheet" href="normalize.css">
		<style>
			i {
				color:black;
			}
			body {
				font-family: 'Roboto',sans serif;
				font-weight: 400;
				font-style: normal;
				color: #6F6D6D;
				margin-left:10vw;
			}
			input {
				width:4em;
				font-family: 'Roboto',sans serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			table {
				table-layout:fixed;
				display:inline-block;
			}
			td {
				width:10vw;
				color:#7f7e7e;
				font-family: 'Roboto',sans serif;
			}
			.tdInput {
				width: fit-content;
			}
			.tdLast {
				width:60vw;
			}
			.textField {
				border-radius: 4px;
				border-color: #dee7e7;
				box-shadow: 1px 1px 0px #6F6D6D;
			}

			.ui-state-default{
				border:0px!important;
			}
			.ui-slider-horizontal {
				height:1px;
				background-color:#425d94;
			}
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-ui.js"></script>
<?php
include('lhs.php');
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function inputPVs($string) {
	preg_match_all("/PV_[0-9]>[^<]+<\/PV_[0-9]/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],5,-6);
	};
	return $input;
}
function inputSPs($string) {
	preg_match_all("/Manual>[^<]+<\/CM_SP_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],7,-8);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function grabSafeties($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<4;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function outputDim($string) {
	preg_match_all("/Dim>[^<]+<\/EO_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=(float)substr($matches[$i],4,-5);
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO) {
	$str.="<tr><td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$i]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField'></div></td>";
		};
	};
	for($i=0;$i<5;$i++) {
		for($j=0;$j<count($outputCheck[$i]);$j++) {
			$num=$i*10+$j+1;
			if($outputCheck[$i][$j]==1) {
				if(isset($EO[$num])) {
					if($EO[$num]==="ON"||$EO[$num]===100||$EO[$num]==="100") {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON' selected>ON</option><option value='OFF'>OFF</option></select></div></td>";
					} else {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
					};
				} else {
					$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
				};
				$eolist[]=$num;
			} else if($outputCheck[$i][$j]==2) {
				$eolist[]=$num;
				$str.="<td><div class='tdelement'>Dimm % $num<input name='EO{$num}[]' type='number' value='".$EO[$num]."' min='0' max='100' step='0.1' class='forceRight textField'></div></td>";
			};
		};
	};
	$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

?>

	</head>
	<body>
<?php
echo LHS('settings'); //TODO:  Grab from server URI.
//echo LHS2('input0',$inputTags,$inputNames); //TODO:  Grab from server URI.
?>
<?php
function writeSlider($name,$setpoint,$minTemp,$maxTemp,$softAlarmLow,$softAlarmHigh,$safetyAlarmLow,$safetyAlarmHigh,$limit2AlarmLow,$limit2AlarmHigh) {
$str="<style>\n";
$str.=".left-color-limit2$name,.left-color-safety$name,.left-color-soft$name,.left-color-setPoint$name {\n";
$str.="	float:left;\n";
$str.="	height:4px;\n";
$str.="	position:relative;\n";
$str.="	top:-2px;\n";
$str.="	border-radius: 3px 0px 0px 3px;\n";
$str.="	width:50px;\n";
$str.="	background-color: #dc4809;\n";
$str.="}\n";
$str.=".right-color-limit2$name,.right-color-safety$name,.right-color-soft$name,.right-color-setPoint$name {\n";
$str.="	float:right;\n";
$str.="	height:4px;\n";
$str.="	position:relative;\n";
$str.="	top:-2px;\n";
$str.="	border-radius: 3px 0px 0px 3px;\n";
$str.="	width:50px;\n";
$str.="	background-color: #dc4809;\n";
$str.="}\n";
$str.=".setpointText$name{\n";
$str.="	color: #159894;\n";
$str.="	font-family: 'Poppins-Bold', 'Poppins Bold', 'Poppins', sans-serif;\n";
$str.="	font-weight: 700;\n";
$str.="	font-size: 14px;\n";
$str.="}\n";
$str.=".softText$name{\n";
$str.="	color: #fec807;\n";
$str.="	font-family: 'Poppins-Bold', 'Poppins Bold', 'Poppins', sans-serif;\n";
$str.="	font-weight: 700;\n";
$str.="	font-size: 14px;\n";
$str.="}\n";
$str.=".safetyText$name{\n";
$str.="	color: #f59c0a;\n";
$str.="	font-family: 'Poppins-Bold', 'Poppins Bold', 'Poppins', sans-serif;\n";
$str.="	font-weight: 700;\n";
$str.="	font-size: 14px;\n";
$str.="}\n";
$str.=".limit2Text$name{\n";
$str.="	color: #dc4809;\n";
$str.="	font-family: 'Poppins-Bold', 'Poppins Bold', 'Poppins', sans-serif;\n";
$str.="	font-weight: 700;\n";
$str.="	font-size: 14px;\n";
$str.="}\n";
$str.="#limit2$name .ui-slider-handle{\n";
$str.="	  width: 0!important; \n";
$str.="	  height: 0!important; \n";
$str.="	  background-color: white!important;\n";
$str.="	  border-left: 10px solid transparent!important;\n";
$str.="	  border-right: 10px solid transparent!important;\n";
$str.="	  border-bottom: 10px solid #dc4809!important;\n";
$str.="	  top:3px!important;\n";
$str.="}\n";
$str.="#safety$name .ui-slider-handle{\n";
$str.="	  width: 0!important; \n";
$str.="	  height: 0!important; \n";
$str.="	  background-color: white!important;\n";
$str.="	  border-left: 10px solid transparent!important;\n";
$str.="	  border-right: 10px solid transparent!important;\n";
$str.="	  border-bottom: 10px solid #f59c0a!important;\n";
$str.="	  top:3px!important;\n";
$str.="}\n";
$str.="#soft$name .ui-slider-handle{\n";
$str.="	  width: 0!important; \n";
$str.="	  height: 0!important; \n";
$str.="	  background-color: white!important;\n";
$str.="	  border-left: 10px solid transparent!important;\n";
$str.="	  border-right: 10px solid transparent!important;\n";
$str.="	  border-bottom: 10px solid #fec807!important;\n";
$str.="	  top:3px!important;\n";
$str.="}\n";
$str.="#setPoint$name .ui-slider-handle{\n";
$str.="	  width: 0!important; \n";
$str.="	  height: 0!important; \n";
$str.="	  background-color: white!important;\n";
$str.="	  border-left: 10px solid transparent!important;\n";
$str.="	  border-right: 10px solid transparent!important;\n";
$str.="	  border-top: 10px solid #159894!important;\n";
$str.="	  top:-13px!important;\n";
$str.="}\n";
$str.="#setpointLine$name{\n";
$str.="	background: #159894;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:90px;\n";
$str.="	width:1px;\n";
$str.="}\n";
if($name=="TEMP") {
$str.="#limit2LineLeft$name{\n";
$str.="	background: #dc4809;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:90px;\n";
$str.="	width:1px;\n";
$str.="}\n";
$str.="#limit2LineRight$name{\n";
$str.="	background: #dc4809;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:90px;\n";
$str.="	width:1px;\n";
$str.="}\n";
$str.="#safetyLineLeft$name{\n";
$str.="	background: #f59c0a;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:65px;\n";
$str.="	width:1px;\n";
$str.="}\n";
$str.="#safetyLineRight$name{\n";
$str.="	background: #f59c0a;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:65px;\n";
$str.="	width:1px;\n";
$str.="}\n";
};
$str.="#softLineLeft$name{\n";
$str.="	background: #fec807;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:40px;\n";
$str.="	width:1px;\n";
$str.="}\n";
$str.="#softLineRight$name{\n";
$str.="	background: #fec807;\n";
$str.="	position:absolute;\n";
$str.="	top:20px;\n";
$str.="	left:380px;\n";
$str.="	height:40px;\n";
$str.="	width:1px;\n";
$str.="}\n";
$str.="</style>\n";
$str.="		<table>\n";
$str.="			<tr><td></td><td></td><td></td><td></td></tr>\n";
$str.="			<tr><td class=\"setpointText$name\">$name Set Point<div id='setpointLine$name'></div></td><td class=\"\"><input type=\"number\" class=\"textField\" id=\"setpointValue$name\"></td><td></td><td class=\"tdLast\"><div id=\"setPoint$name\"><div class=\"left-color-soft$name\"></div><div class=\"right-color-soft$name\"></div></div></td></tr>\n";
$str.="			<tr><td></td><td></td></tr>\n";
$str.="			<tr><td class=\"softText$name\">$name Soft Hi/Lo<div id='softLineLeft$name'></div><div id='softLineRight$name'></div></td><td><input type=\"number\" class=\"textField\" id=\"leftSoftValue$name\"></td><td><input type=\"number\" class=\"textField\" id=\"rightSoftValue$name\"></td><td class=\"tdLast\"><div id=\"soft$name\"><div class=\"left-color-soft$name\"></div><div class=\"right-color-soft$name\"></div></div></td></tr>\n";
$str.="			<tr><td></td><td></td></tr>\n";
if($name=="TEMP") {
$str.="			<tr><td class=\"safetyText$name\">$name Safety Hi/Lo<div id='safetyLineLeft$name'></div><div id='safetyLineRight$name'></div></td><td><input type=\"number\" class=\"textField\" id=\"leftSafetyValue$name\"></td><td><input type=\"number\" class=\"textField\" id=\"rightSafetyValue$name\"></td><td class=\"tdLast\"><div id=\"safety$name\"><div class=\"left-color-safety$name\"></div><div class=\"right-color-safety$name\"></div></div></td></tr>\n";
$str.="			<tr><td></td><td></td></tr>\n";
$str.="			<tr><td class=\"limit2Text$name\">$name Limit2 Hi/Lo<div id='limit2LineLeft$name'></div><div id='limit2LineRight$name'></div></td><td><input type=\"number\" class=\"textField\" id=\"leftLimit2Value$name\"></td><td><input type=\"number\" class=\"textField\" id=\"rightLimit2Value$name\"></td><td class=\"tdLast\"><div id=\"limit2$name\"><div class=\"left-color-limit2$name\"></div><div class=\"right-color-limit2$name\"></div></div></td></tr>\n";
};
$str.="		</table>\n";
$str.="		\n";
$str.="		\n";
$str.="		\n";
$str.="		\n";
$str.="		\n";
$str.="		\n";
$str.="		\n";
$str.="		<script>\n";
$str.="			$( function() {\n";
$str.="				var setpoint=$setpoint;\n";
$str.="				var minTemp=$minTemp;\n";
$str.="				var maxTemp=$maxTemp;\n";
$str.="				var softAlarmLow=$softAlarmLow;\n";
$str.="				var softAlarmHigh=$softAlarmHigh;\n";
$str.="				var safetyAlarmLow=$safetyAlarmLow;\n";
$str.="				var safetyAlarmHigh=$safetyAlarmHigh;\n";
$str.="				var limit2AlarmLow=$limit2AlarmLow;\n";
$str.="				var limit2AlarmHigh=$limit2AlarmHigh;\n";
$str.="				$( \"#setPoint$name\" ).slider({\n";
$str.="					min: 0,\n";
$str.="					max: 100,\n";
$str.="					values: [ (setpoint-minTemp)*100/(maxTemp-minTemp)],\n";
$str.="					slide: function(event,ui) {\n";
$str.="						$(\"#setpointLine$name\").css({left:$(\"#setPoint$name\").position().left+$('.tdLast').outerWidth()*ui.values[0]/100-0.5});\n";
$str.="						document.getElementById(\"setpointValue$name\").value=ui.values[0]*(maxTemp-minTemp)/100+minTemp;\n";
$str.="					}\n";
$str.="				});\n";
$str.="				$( \"#setpointValue$name\" ).change(function() {\n";
$str.="					$(\"#setPoint$name\").slider(\"option\",\"values\",[100*($(\"#setpointValue$name\").val()-minTemp)/(maxTemp-minTemp)]);\n";
$str.="					$(\"#setpointLine$name\").css({left:$(\"#setPoint$name\").position().left+$('.tdLast').outerWidth()*($(\"#setpointValue$name\").val()-minTemp)/(maxTemp-minTemp)});\n";
$str.="				});\n";
$str.="				document.getElementById(\"setpointValue$name\").value=setpoint;\n";
$str.="				$(\"#setpointLine$name\").css({left:$(\"#setPoint$name\").position().left+$('.tdLast').outerWidth()*(setpoint-minTemp)/(maxTemp-minTemp)});\n";
if($name=="TEMP") {
$str.="				$( \"#limit2$name\" ).slider({\n";
$str.="					min: 0,\n";
$str.="					max: 100,\n";
$str.="					values: [ (limit2AlarmLow-minTemp)*100/(maxTemp-minTemp), (limit2AlarmHigh-minTemp)*100/(maxTemp-minTemp) ],\n";
$str.="					//classes: { \"ui-slider-handle\": \"test\" },\n";
$str.="					slide: function(event,ui) {\n";
$str.="						var totalWidth= $(\"#limit2$name\").width();\n";
$str.="						var leftlimit2width= Math.max(ui.values[0])/100*totalWidth;\n";
$str.="						var rightlimit2width= totalWidth-Math.min(ui.values[1]/100*totalWidth);\n";
$str.="						var leftsafetywidth= Math.max($(\"#safety$name\").slider(\"values\",0),ui.values[0])/100*totalWidth;\n";
$str.="						var rightsafetywidth= totalWidth-Math.min($(\"#safety$name\").slider(\"values\",1),ui.values[1])/100*totalWidth;\n";
$str.="						var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0),$(\"#safety$name\").slider(\"values\",0),ui.values[0])/100*totalWidth;\n";
$str.="						var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1),$(\"#safety$name\").slider(\"values\",1),ui.values[1])/100*totalWidth;\n";
$str.="						$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="						$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="						$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="						$(\".right-color-safety$name\").width(rightsafetywidth);\n";
$str.="						$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="						$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="						$(\"#limit2LineLeft$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*ui.values[0]/100});\n";
$str.="						$(\"#limit2LineRight$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*ui.values[1]/100});\n";
$str.="						document.getElementById(\"leftLimit2Value$name\").value=ui.values[0]*(maxTemp-minTemp)/100+minTemp;\n";
$str.="						document.getElementById(\"rightLimit2Value$name\").value=ui.values[1]*(maxTemp-minTemp)/100+minTemp;\n";
$str.="					}\n";
$str.="				});\n";
$str.="\n";
$str.="				$( \"#leftLimit2Value$name\" ).change(function() {\n";
$str.="					$(\"#limit2$name\").slider(\"option\",\"values\",[100*($(\"#leftLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp),100*($(\"#rightLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp)]);\n";
$str.="					$(\"#limit2LineLeft$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*($(\"#leftLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var leftlimit2width= Math.max($(\"#leftLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var leftsafetywidth= Math.max($(\"#safety$name\").slider(\"values\",0)/100,$(\"#leftLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0)/100,$(\"#safety$name\").slider(\"values\",0)/100,$(\"#leftLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="					$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="					$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"leftLimit2Value$name\").value=limit2AlarmLow;\n";
$str.="				$(\"#limit2LineLeft$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*(limit2AlarmLow-minTemp)/(maxTemp-minTemp)});\n";
$str.="\n";
$str.="				$( \"#rightLimit2Value$name\" ).change(function() {\n";
$str.="					$(\"#limit2$name\").slider(\"option\",\"values\",[100*($(\"#leftLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp),100*($(\"#rightLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp)]);\n";
$str.="					$(\"#limit2LineRight$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*($(\"#rightLimit2Value$name\").val()-minTemp)/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var rightlimit2width= totalWidth-Math.min($(\"#rightLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var rightsafetywidth= totalWidth-Math.min($(\"#safety$name\").slider(\"values\",1)/100,$(\"#rightLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1)/100,$(\"#safety$name\").slider(\"values\",1)/100,$(\"#rightLimit2Value$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="					$(\".right-color-safety$name\").width(rightsafetywidth);\n";
$str.="					$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"rightLimit2Value$name\").value=limit2AlarmHigh;\n";
$str.="				$(\"#limit2LineRight$name\").css({left:$(\"#limit2$name\").position().left+$('.tdLast').outerWidth()*(limit2AlarmHigh-minTemp)/(maxTemp-minTemp)});\n";
$str.="\n";
$str.="				$( \"#safety$name\" ).slider({\n";
$str.="					min: 0,\n";
$str.="					max: 100,\n";
$str.="					values: [ safetyAlarmLow*100/(maxTemp-minTemp), safetyAlarmHigh*100/(maxTemp-minTemp) ],\n";
$str.="					slide: function(event,ui) {\n";
$str.="						var totalWidth= $(\"#limit2$name\").width();\n";
$str.="						var leftlimit2width= Math.max($(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="						var rightlimit2width= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100*totalWidth);\n";
$str.="						var leftsafetywidth= Math.max($(\"#limit2$name\").slider(\"values\",0),ui.values[0])/100*totalWidth;\n";
$str.="						var rightsafetywidth= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1),ui.values[1])/100*totalWidth;\n";
$str.="						var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0),$(\"#limit2$name\").slider(\"values\",0),ui.values[0])/100*totalWidth;\n";
$str.="						var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1),$(\"#limit2$name\").slider(\"values\",1),ui.values[1])/100*totalWidth;\n";
$str.="						$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="						$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="						$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="						$(\".right-color-safety$name\").width(rightsafetywidth);\n";
$str.="						$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="						$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="						$(\"#safetyLineLeft$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*ui.values[0]/100});\n";
$str.="						$(\"#safetyLineRight$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*ui.values[1]/100});\n";
$str.="						document.getElementById(\"leftSafetyValue$name\").value=ui.values[0]*(maxTemp-minTemp)/100;\n";
$str.="						document.getElementById(\"rightSafetyValue$name\").value=ui.values[1]*(maxTemp-minTemp)/100;\n";
$str.="					}\n";
$str.="				});\n";
$str.="\n";
$str.="				$( \"#leftSafetyValue$name\" ).change(function() {\n";
$str.="					$(\"#safety$name\").slider(\"option\",\"values\",[100*$(\"#leftSafetyValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSafetyValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#safetyLineLeft$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*$(\"#leftSafetyValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var leftlimit2width= Math.max($(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="					var leftsafetywidth= Math.max($(\"#limit2$name\").slider(\"values\",0)/100,$(\"#leftSafetyValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0)/100,$(\"#limit2$name\").slider(\"values\",0)/100,$(\"#leftSafetyValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="					$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="					$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"leftSafetyValue$name\").value=safetyAlarmLow;\n";
$str.="				$(\"#safetyLineLeft$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*safetyAlarmLow/(maxTemp-minTemp)});\n";
$str.="\n";
$str.="				$( \"#rightSafetyValue$name\" ).change(function() {\n";
$str.="					$(\"#safety$name\").slider(\"option\",\"values\",[100*$(\"#leftSafetyValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSafetyValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#safetyLineRight$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*$(\"#rightSafetyValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var rightlimit2width= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100*totalWidth);\n";
$str.="					var rightsafetywidth= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100,$(\"#rightSafetyValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1)/100,$(\"#limit2$name\").slider(\"values\",1)/100,$(\"#rightSafetyValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="					$(\".right-color-safety$name\").width(rightsafetywidth);\n";
$str.="					$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"rightSafetyValue$name\").value=safetyAlarmHigh;\n";
$str.="				$(\"#safetyLineRight$name\").css({left:$(\"#safety$name\").position().left+$('.tdLast').outerWidth()*safetyAlarmHigh/(maxTemp-minTemp)});\n";
};
$str.="\n";
$str.="				$( \"#soft$name\" ).slider({\n";
$str.="					min: 0,\n";
$str.="					max: 100,\n";
$str.="					values: [ softAlarmLow*100/(maxTemp-minTemp), softAlarmHigh*100/(maxTemp-minTemp)  ],\n";
$str.="					slide: function(event,ui) {\n";
if($name=="TEMP") {
$str.="						var totalWidth= $(\"#limit2$name\").width();\n";
$str.="						var leftlimit2width= Math.max($(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="						var rightlimit2width= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100*totalWidth);\n";
$str.="						var leftsafetywidth= Math.max($(\"#limit2$name\").slider(\"values\",0),$(\"#safety$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="						var rightsafetywidth= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1),$(\"#safety$name\").slider(\"values\",1))/100*totalWidth;\n";
$str.="						var leftsoftwidth= Math.max($(\"#safety$name\").slider(\"values\",0),$(\"#limit2$name\").slider(\"values\",0),ui.values[0])/100*totalWidth;\n";
$str.="						var rightsoftwidth= totalWidth-Math.min($(\"#safety$name\").slider(\"values\",1),$(\"#limit2$name\").slider(\"values\",1),ui.values[1])/100*totalWidth;\n";
} else {
$str.="						var totalWidth= $(\"#soft$name\").width();\n";
$str.="						var leftsoftwidth= Math.max(ui.values[0])/100*totalWidth;\n";
$str.="						var rightsoftwidth= totalWidth-Math.min(ui.values[1])/100*totalWidth;\n";
};
if($name=="TEMP") {
$str.="						$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="						$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="						$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="						$(\".right-color-safety$name\").width(rightsafetywidth);\n";
};
$str.="						$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="						$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="						$(\"#softLineLeft$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*ui.values[0]/100});\n";
$str.="						$(\"#softLineRight$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*ui.values[1]/100});\n";
$str.="						document.getElementById(\"leftSoftValue$name\").value=ui.values[0]*(maxTemp-minTemp)/100;\n";
$str.="						document.getElementById(\"rightSoftValue$name\").value=ui.values[1]*(maxTemp-minTemp)/100;\n";
$str.="					}\n";
$str.="				});\n";
$str.="				$( \"#leftSoftValue$name\" ).change(function() {\n";
if($name=="TEMP") {
$str.="					$(\"#soft$name\").slider(\"option\",\"values\",[100*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#softLineLeft$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var leftlimit2width= Math.max($(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="					var leftsafetywidth= Math.max($(\"#limit2$name\").slider(\"values\",0)/100,$(\"#safety$name\").slider(\"values\",0)/100)*totalWidth;\n";
$str.="					var leftsoftwidth= Math.max($(\"#safety$name\").slider(\"values\",0)/100,$(\"#limit2$name\").slider(\"values\",0)/100,$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="					$(\".left-color-safety$name\").width(leftsafetywidth);\n";
} else {
$str.="					$(\"#soft$name\").slider(\"option\",\"values\",[100*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#softLineLeft$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#soft$name\").width();\n";
$str.="					var leftsoftwidth= Math.max($(\"#leftSoftValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
};
$str.="					$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"leftSoftValue$name\").value=softAlarmLow;\n";
$str.="				$(\"#softLineLeft$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*softAlarmLow/(maxTemp-minTemp)});\n";
$str.="\n";
$str.="				$( \"#rightSoftValue$name\" ).change(function() {\n";
if($name=="TEMP") {
$str.="					$(\"#soft$name\").slider(\"option\",\"values\",[100*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#softLineRight$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#limit2$name\").width();\n";
$str.="					var rightlimit2width= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100*totalWidth);\n";
$str.="					var rightsafetywidth= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100,$(\"#safety$name\").slider(\"values\",1)/100)*totalWidth;\n";
$str.="					var rightsoftwidth= totalWidth-Math.min($(\"#safety$name\").slider(\"values\",1)/100,$(\"#limit2$name\").slider(\"values\",1)/100,$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
$str.="					$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.="					$(\".right-color-safety$name\").width(rightsafetywidth);\n";
} else {
$str.="					$(\"#soft$name\").slider(\"option\",\"values\",[100*$(\"#leftSoftValue$name\").val()/(maxTemp-minTemp),100*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)]);\n";
$str.="					$(\"#softLineRight$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*$(\"#rightSoftValue$name\").val()/(maxTemp-minTemp)});\n";
$str.="					var totalWidth= $(\"#soft$name\").width();\n";
$str.="					var rightsoftwidth= totalWidth-Math.min($(\"#rightSoftValue$name\").val()/(maxTemp-minTemp))*totalWidth;\n";
};
$str.="					$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="				});\n";
$str.="				document.getElementById(\"rightSoftValue$name\").value=softAlarmHigh;\n";
$str.="				$(\"#softLineRight$name\").css({left:$(\"#soft$name\").position().left+$('.tdLast').outerWidth()*softAlarmHigh/(maxTemp-minTemp)});\n";
$str.="			} );\n";
$str.="setTimeout(function(){\n";
if($name=="TEMP") {
$str.="	var totalWidth= $(\"#limit2$name\").width();\n";
$str.="	var leftlimit2width= Math.max($(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="	var rightlimit2width= totalWidth-Math.min($(\"#limit2$name\").slider(\"values\",1)/100*totalWidth);\n";
$str.="	var leftsafetywidth= Math.max($(\"#safety$name\").slider(\"values\",0),$(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="	var rightsafetywidth= totalWidth-Math.min($(\"#safety$name\").slider(\"values\",1),$(\"#limit2$name\").slider(\"values\",1))/100*totalWidth;\n";
$str.="	var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0),$(\"#safety$name\").slider(\"values\",0),$(\"#limit2$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="	var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1),$(\"#safety$name\").slider(\"values\",1),$(\"#limit2$name\").slider(\"values\",1))/100*totalWidth;\n";
$str.="	$(\".left-color-limit2$name\").width(leftlimit2width);\n";
$str.="	$(\".right-color-limit2$name\").width(rightlimit2width);\n";
$str.=" $(\"#limit2LineLeft$name\").css({top:$(\"#limit2$name\").position().top+$('.tdLast').position().top-101});\n";
$str.=" $(\"#limit2LineRight$name\").css({top:$(\"#limit2$name\").position().top+$('.tdLast').position().top-101});\n";
$str.=" $(\"#safetyLineLeft$name\").css({top:$(\"#safety$name\").position().top+$('.tdLast').position().top-74});\n";
$str.=" $(\"#safetyLineRight$name\").css({top:$(\"#safety$name\").position().top+$('.tdLast').position().top-74});\n";
$str.="	$(\".left-color-safety$name\").width(leftsafetywidth);\n";
$str.="	$(\".right-color-safety$name\").width(rightsafetywidth);\n";
$str.=" $(\"#setpointLine$name\").css({height:93});\n";
//$str.=" $(\"#softLineLeft$name\").css({height:93});\n";
//$str.=" $(\"#softLineRight$name\").css({height:93});\n";
//$str.=" $(\"#safetyLineLeft$name\").css({height:93});\n";
//$str.=" $(\"#safetyLineRight$name\").css({height:93});\n";
//$str.=" $(\"#limit2LineLeft$name\").css({height:93});\n";
//$str.=" $(\"#limit2LineRight$name\").css({height:93});\n";
} else {
$str.="	var totalWidth= $(\"#soft$name\").width();\n";
$str.="	var leftsoftwidth= Math.max($(\"#soft$name\").slider(\"values\",0))/100*totalWidth;\n";
$str.="	var rightsoftwidth= totalWidth-Math.min($(\"#soft$name\").slider(\"values\",1))/100*totalWidth;\n";
$str.=" $(\"#setpointLine$name\").css({height:66});\n";
//$str.=" $(\"#softLineLeft$name\").css({height:66});\n";
//$str.=" $(\"#softLineRight$name\").css({height:66});\n";
//$str.=" $(\"#safetyLineLeft$name\").css({height:66});\n";
//$str.=" $(\"#safetyLineRight$name\").css({height:66});\n";
};
$str.=" $(\"#setpointLine$name\").css({top:$(\"#setPoint$name\").position().top+$('.tdLast').position().top-20});\n";
$str.=" $(\"#softLineLeft$name\").css({top:$(\"#soft$name\").position().top+$('.tdLast').position().top-42});\n";
$str.=" $(\"#softLineRight$name\").css({top:$(\"#soft$name\").position().top+$('.tdLast').position().top-42});\n";
$str.="	$(\".left-color-soft$name\").width(leftsoftwidth);\n";
$str.="	$(\".right-color-soft$name\").width(rightsoftwidth);\n";
$str.="},200); // 200 = 0.2 seconds = 200 miliseconds\n";
$str.="		</script>\n";
echo $str;
};
$name="TEMP";
$setpoint=25;
$minTemp=0;
$maxTemp=50;
$softAlarmLow=15;
$softAlarmHigh=30;
$safetyAlarmLow=10;
$safetyAlarmHigh=35;
$limit2AlarmLow=9;
$limit2AlarmHigh=36;
//GRAB CONTROLLER DATA TO CORRECTLY SET UP Dashboard.
$inputNames="http://10.2.0.5/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputSPs="http://10.2.0.5/read_data.xml?Cmd=read&Tag=CM_SP_1_Manual&Tag=CM_SP_2_Manual&Tag=CM_SP_3_Manual&Tag=CM_SP_4_Manual&Tag=CM_SP_5_Manual&Tag=CM_SP_6_Manual&Tag=CM_SP_7_Manual";
$inputTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$highRangeTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=CLC_SP_High_1&Tag=CLC_SP_High_2&Tag=CLC_SP_High_3&Tag=CLC_SP_High_4&Tag=CLC_SP_High_5&Tag=CLC_SP_High_6&Tag=CLC_SP_High_7";
$lowRangeTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=CLC_SP_Low_1&Tag=CLC_SP_Low_2&Tag=CLC_SP_Low_3&Tag=CLC_SP_Low_4&Tag=CLC_SP_Low_5&Tag=CLC_SP_Low_6&Tag=CLC_SP_Low_7";
$highSoftTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=ALM_Temp_Soft_Alarm_High&Tag=ALM_Rh_Soft_Alarm_High&Tag=ALM_Aux_Soft_High&Tag=ALM_Input4_Soft_Alarm_High&Tag=ALM_Input5_Soft_Alarm_High&Tag=ALM_Input6_Soft_Alarm_High&Tag=ALM_Input7_Soft_Alarm_High";
$lowSoftTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=ALM_Temp_Soft_Alarm_Low&Tag=ALM_Rh_Soft_Alarm_Low&Tag=ALM_Aux_Soft_Low&Tag=ALM_Input4_Soft_Alarm_Low&Tag=ALM_Input5_Soft_Alarm_Low&Tag=ALM_Input6_Soft_Alarm_Low&Tag=ALM_Input7_Soft_Alarm_Low";
$safetyTags="http://10.2.0.5/read_data.xml?Cmd=read&Tag=ALM_Temp_Safety_Alarm_Low&Tag=ALM_Temp_Safety_Alarm_High&Tag=ALM_Temp_Limit2_Alarm_Low&Tag=ALM_Temp_Limit2_Alarm_High";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $inputNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputSPs);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputSPs=inputSPs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$highRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$lowRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highSoftTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$highSoftTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowSoftTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$lowSoftTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $safetyTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$safetyTags=grabSafeties(curl_exec($ch));
$lowRangeTags[0]=-10;
$lowSoftTags[0]=max($lowRangeTags[0],$lowSoftTags[0]);
$highSoftTags[0]=min($highRangeTags[0],$highSoftTags[0]);
$safetyAlarmLow=max($lowRangeTags[0],$safetyTags[0]);
$safetyAlarmHigh=min($highRangeTags[0],$safetyTags[1]);
$limit2AlarmLow=max($lowRangeTags[0],$safetyTags[2]);
$limit2AlarmHigh=min($highRangeTags[0],$safetyTags[3]);
curl_setopt($ch, CURLOPT_URL, $inputTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputTags=inputCheck(curl_exec($ch));
		//writeSlider(trim($inputNames[0]),$inputSPs[0],0,$highRangeTags[0],0,$highSoftTags[0],0,$safetyAlarmHigh,0,$limit2AlarmHigh);
		//writeSlider(trim($inputNames[0]),$inputSPs[0],$lowRangeTags[0],$highRangeTags[0],$lowSoftTags[0],$highSoftTags[0],$safetyAlarmLow,$safetyAlarmHigh,$limit2AlarmLow,$limit2AlarmHigh);
		//writeSlider(trim($inputNames[1]),$inputSPs[1],$lowRangeTags[1],$highRangeTags[1],$lowSoftTags[1],$highSoftTags[1],$safetyAlarmLow,$safetyAlarmHigh,$limit2AlarmLow,$limit2AlarmHigh);
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		//writeSlider(trim($inputNames[$i]),$inputSPs[$i],$lowRangeTags[$i],$highRangeTags[$i],$softAlarmLow,$softAlarmHigh,$safetyAlarmLow,$safetyAlarmHigh,$limit2AlarmLow,$limit2AlarmHigh);
	};
};
curl_close($ch);
?>
<style>
.left-color-limit2,.left-color-safety,.left-color-soft,.left-color-setPoint,.left-color {
	float:left;
	height:2px;
	position:relative;
	top:-1px;
	border-radius: 3px 0px 0px 3px;
	width:50px;
	background-color: #b8b8b8;
}
.right-color-limit2,.right-color-safety,.right-color-soft,.right-color-setPoint,.right-color {
	float:right;
	height:2px;
	position:relative;
	top:-1px;
	border-radius: 3px 0px 0px 3px;
	width:50px;
	background-color: #c3c3e6;
}
#alarms .ui-slider-handle:nth-of-type(1){
	  background-color: #425d94;
	  height: 16px;
	  width: 16px;
	  border-radius: 510%;
	  margin-top: -3px;
	  cursor: pointer;
}
#alarms .ui-slider-handle:nth-of-type(2),#alarms .ui-slider-handle:nth-of-type(3){
	  background-color: #3f796b;
	  height: 10px;
	  width: 10px;
	  border-radius: 510%;
	  cursor: pointer;
}
#alarms .ui-slider-handle:nth-of-type(4),#alarms .ui-slider-handle:nth-of-type(5){
	  background-color: #3f796b;
	  height: 10px;
	  width: 10px;
	  border-radius: 510%;
	  cursor: pointer;
}
#alarms .ui-slider-handle:nth-of-type(6),#alarms .ui-slider-handle:nth-of-type(7){
	  background-color: #3f796b;
	  height: 10px;
	  width: 10px;
	  border-radius: 510%;
	  cursor: pointer;
}
#alarms .ui-state-active{
	animation: pulse 1s;
/*	box-shadow: 0 0 0px 10px #dee7e7;*/
}
@keyframes pulse {
	0% {box-shadow: 0 0 0px 0px #dee7e7;}
	50% {box-shadow: 0 0 0px 10px #dee7e7;}
	100% {box-shadow: 0 0 0px 0px #dee7e7;}
}
td {
	text-align:center;
}
.setpointText{
  	font-family: 'Roboto',sans serif;
	font-weight: 400;
	color: #425d94;
	outline: none;
	border: 0;
	height: 24px;
	font-size: 20px;
	text-align: center;
}
input.setpointText{ 
	background-color: #dee7e7;
	border-bottom: 3px solid #425d94;
	border-radius: 10%;
}
input.setpointText:hover,input.setpointText:focus{ 
	background-color: #c3c3e6;
	border-bottom: 6px solid #425d94;
	border-radius: 10%;
}
.limit2Text{
  	font-family: 'Roboto',sans serif;
	font-weight: 400;
	color: #3f796b;
	outline: none;
	border: 0;
	height: 20px;
	font-size: 16px;
	text-align: center;
}
input.limit2Text{ 
	background-color: #dee7e7;
	border-bottom: 3px solid #3f796b;
	border-radius: 10%;
}
input.limit2Text:hover,input.limit2Text:focus{ 
	background-color: #c3c3e6;
	border-bottom: 6px solid #3f796b;
	border-radius: 10%;
}
.safetyText{
  	font-family: 'Roboto',sans serif;
	font-weight: 400;
	color: #3f796b;
	outline: none;
	border: 0;
	height: 20px;
	font-size: 16px;
	text-align: center;
}
.footballGoal{
	border-right: 2px solid #3f796b;
	border-left: 2px solid #3f796b;
}
input.safetyText{ 
	background-color: #dee7e7;
	border-bottom: 3px solid #3f796b;
	border-radius: 10%;
}
input.safetyText:hover,input.safetyText:focus{ 
	background-color: #c3c3e6;
	border-bottom: 6px solid #3f796b;
	border-radius: 10%;
}
.softText{
  	font-family: 'Roboto',sans serif;
	font-weight: 400;
	color: #3f796b;
	outline: none;
	border: 0;
	height: 20px;
	font-size: 16px;
	text-align: center;
}
input.softText{ 
	background-color: #dee7e7;
	border-bottom: 3px solid #3f796b;
	border-radius: 10%;
}
input.softText:hover,input.softText:focus{ 
	background-color: #c3c3e6;
	border-bottom: 6px solid #3f796b;
	border-radius: 10%;
}
input[type=number]::-webkit-inner-spin-button,input[type=number]::-webkit-out-spin-button {
	-webkit-appearance: none;
	margin: 0;
	opacity: 0;
}
.move {
	position: relative;
	top: 5px;
}
</style>
		<table>
			<tr><td class="limit2Text">Lim2</td><td class="safetyText">Safety</td><td class="softText">Soft</td>
				 <td class="setpointText">Setpoint</td>
				 <td class="softText">Soft</td></td><td class="safetyText">Safety</td><td class="limit2Text">Lim2</td></tr>
			<tr><td><input type="number" id="limit2AlarmLowValue" value="5" class="limit2Text"></td> <td><input type="number" id="safetyAlarmLowValue" value="10" class="safetyText"></td> <td><input type="number" id="softAlarmLowValue" value="15" class="softText"></td>
				 <td><input type="number" id="setpointValue" class="setpointText" value="20"></td>
				 <td><input type="number" id="softAlarmHighValue" value="30" class="softText"></td> <td><input type="number" id="safetyAlarmHighValue" value="40" class="safetyText"></td> <td><input type="number" id="limit2AlarmHighValue" value="45" class="limit2Text"></td> </tr>
			<tr class="move"><td class="tdLast" colspan="7"><div id="alarms"><div class="left-color"></div><div class="right-color"></div></div></td></tr>
		</table>
<script>
var setpoint=20;
var minTemp=-10;
var maxTemp=50;
var softAlarmLow=15;
var softAlarmHigh=30;
var safetyAlarmLow=10;
var safetyAlarmHigh=40;
var limit2AlarmLow=5;
var limit2AlarmHigh=45;
$( "#alarms" ).slider({
	min: 0,
	max: 100,
	step: 0.1,
	values: [(setpoint-minTemp)*100/(maxTemp-minTemp),
		(limit2AlarmLow-minTemp)*100/(maxTemp-minTemp), (limit2AlarmHigh-minTemp)*100/(maxTemp-minTemp),
		(safetyAlarmLow-minTemp)*100/(maxTemp-minTemp), (safetyAlarmHigh-minTemp)*100/(maxTemp-minTemp),
		(softAlarmLow-minTemp)*100/(maxTemp-minTemp), (softAlarmHigh-minTemp)*100/(maxTemp-minTemp),
	],
	//classes: { "ui-slider-handle": "test" },
	slide: function(event,ui) {
		var totalWidth= $("#alarms").width();
		var leftalarmwidth= Math.max(ui.values[1],ui.values[3],ui.values[5])/100*totalWidth;
		var rightalarmwidth= totalWidth-Math.min(ui.values[2],ui.values[4],ui.values[6])/100*totalWidth;
		$(".left-color").width(leftalarmwidth);
		$(".right-color").width(rightalarmwidth);
		document.getElementById("setpointValue").value=(ui.values[0]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("limit2AlarmLowValue").value=(ui.values[1]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("limit2AlarmHighValue").value=(ui.values[2]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("safetyAlarmLowValue").value=(ui.values[3]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("safetyAlarmHighValue").value=(ui.values[4]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("softAlarmLowValue").value=(ui.values[5]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
		document.getElementById("softAlarmHighValue").value=(ui.values[6]*(maxTemp-minTemp)/100+minTemp).toFixed(1);
	}
});
$( "#setpointValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#limit2AlarmLowValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#limit2AlarmHighValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#safetyAlarmLowValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#safetyAlarmHighValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#softAlarmLowValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
$( "#softAlarmHighValue" ).change(function() {
	$("#alarms").slider("option","values",[100*($("#setpointValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#limit2AlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#limit2AlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#safetyAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#safetyAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
		,100*($("#softAlarmLowValue").val()-minTemp)/(maxTemp-minTemp),100*($("#softAlarmHighValue").val()-minTemp)/(maxTemp-minTemp)
	]);
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
});
setTimeout(function(){
	var totalWidth= $("#alarms").width();
	var leftalarmwidth= Math.max($("#alarms").slider("values",1),$("#alarms").slider("values",3),$("#alarms").slider("values",5))/100*totalWidth;
	var rightalarmwidth= totalWidth-Math.min($("#alarms").slider("values",2),$("#alarms").slider("values",4),$("#alarms").slider("values",6))/100*totalWidth;
	$(".left-color").width(leftalarmwidth);
	$(".right-color").width(rightalarmwidth);
},200); // 200 = 0.2 seconds = 200 miliseconds
</script>

	</body>
</html>

