<?php
ini_set("display_errors",1);
error_reporting(E_ALL);
date_default_timezone_set("UTC"); 
require_once 'lib/swift_required.php';
set_time_limit(0); //The program can be ended manually by  resetting the frequency text file or an abnormal fault on the computer.
$fname="debugger.txt";
$nfile = fopen($fname, "w");
if($nfile != false) { 
	fwrite($nfile,"1");
	fclose($nfile);
};

//Grab the frequency data.
$filename = "frequency.txt";
$handle = fopen($filename, "rb");
$arguments= fread($handle, filesize($filename));
fclose($handle);
//Grab the time of the "last" mail.
$filename = "last.txt";
$handle = fopen($filename, "rb");
$last= fread($handle, filesize($filename));
fclose($handle);

if($arguments=="0") {
	//Don't do anything!
} else {
	$inputs=explode(",",$arguments);
	$username = $inputs[0];
	$password = $inputs[1];
	$frequency = $inputs[2];
	$initial = $inputs[3];
	$email1= $inputs[4];
	$email2= $inputs[5];
	$email3= $inputs[6];
	$email4= $inputs[7];
	$smtp= $inputs[8];
	$port= $inputs[9];
	$type= $inputs[10];
/*
	var_dump($inputs);
	$frequency = 60;
	$initial = 9;
	$email1= '';
	$email2= '';
	$email3= '';
	$email4= '';
	$smtp='10.1.1.119';
	$port='25';
	$type='na';
*/
	//Mainly a lot of parsing functions for the Intellus XML.
	function inputNames($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<7;$i++) {
			$input[$i]=substr($matches[$i],1,-2);
		};
		return $input;
	}
	function macAddressAndLights($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<2;$i++) {
			$input[$i]=substr($matches[$i],1,-2);
		};
		return $input;
	}
	function alarmStatus($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		$alarmStatus=0;
		foreach($matches as $i=>$match) {
			if(substr($match,1,-2)!="Off"&&$i>1) {
				$alarmStatus=1;
			}
		};
		return $alarmStatus;
	}
	function inputPVs($string) {
		preg_match_all("/PV_[0-9]>[^<]+<\/PV_[0-9]/",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<7;$i++) {
			$input[$i]=(float) substr($matches[$i],5,-6);
		};
		return $input;
	}
	function inputSPs($string) {
		preg_match_all("/Manual>[^<]+<\/CM_SP_/",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<7;$i++) {
			$input[$i]=(float) substr($matches[$i],7,-8);
		};
		return $input;
	}
	function grabRange($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<7;$i++) {
			$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
		};
		return $input;
	}
	function inputCheck($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		$input[0]="C";
		for($i=0;$i<6;$i++) {
			$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
			if($input[$i+1]) {
				$input[$i+1]=substr($matches[3*$i+2],1,-2);
			};
		};
		return $input;
	}
	function outputCheck($string) {
		preg_match_all("/>[^<]+<\//",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<count($matches);$i++) {
			$output[$i]=0;
			if(strpos($matches[$i],'On')) {
				$output[$i]=1;
			};
			if(strpos($matches[$i],'Dimming')) {
				$output[$i]=2;
			};
		};
		return $output;
	}
	function outputDim($string) {
		preg_match_all("/Dim>[^<]+<\/EO_/",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<count($matches);$i++) {
			$output[$i]=(float)substr($matches[$i],4,-5);
		};
		return $output;
	}
	function programNames($string) {
		preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
		$matches=$matches[0];
		for($i=0;$i<count($matches);$i++) {
			$names[$i]=substr($matches[$i],5,-6);
		};
		return $names;
	}
	function stepCheck($string) {
		preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
		$matches=$matches[0];
		if(empty($matches)) {
			return 1;
		} else {
			return 0;
		};
	};
	function stepTime($string) {
		preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
		$matches=$matches[0][0];
		$time=intval(substr($matches,5,-6));
		$second=$time%60;
		$minute=(($time-$second*60)/60)%60;
		$hour=($time-$minute*60-$second*3600)/3600;
		if(strlen($minute)==1) {
			$minute="0".$minute;
		};
		if(strlen($hour)==1) {
			$hour="0".$hour;
		};
		$time=$hour.":".$minute;
		return $time;
	};
	function stepSP($string,$inputTags) {
		$SP=[];
		for($i=0;$i<7;$i++) {
			$j=$i+1;
			preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
			$matches=$matches[0][0];
			if($inputTags[$i]) {
				$SP[$i]=intval(substr($matches,4,-5))/1000;
			} else {
				$SP[$i]=0;//Default value.
			};
		};
		return $SP;
	};
	function stepEO($string,$eolist) {
		for($i=1;$i<48;$i++) {
			$EO[$i]=0;
		};
		foreach($eolist as $num) {
			preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
			$matches=substr($matches[0][0],4,-5);
			if($matches==="ON") {
				$matches=10000;
			} elseif($matches==="OFF") {
				$matches=0;
			} else {
				$matches=intval($matches)/100;
			};
			$EO[$num]=$matches;
		};
		return $EO;
	};
	function clock2Minutes($clockTime) {
		$hourMinute=explode(":",$clockTime);
		return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
	};
	function toZero($num) {
		return 0;
	};
	//END FUNCTION DECLARATIONS

	//GRAB CONTROLLER DATA TO CORRECTLY SET UP Dashboard.
	$inputNames="http://192.168.1.1/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
	$inputPVs="http://192.168.1.1/read_data.xml?Cmd=read&Tag=PV_1&Tag=PV_2&Tag=PV_3&Tag=PV_4&Tag=PV_5&Tag=PV_6&Tag=PV_7";
	$inputSPs="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CM_SP_1_Manual&Tag=CM_SP_2_Manual&Tag=CM_SP_3_Manual&Tag=CM_SP_4_Manual&Tag=CM_SP_5_Manual&Tag=CM_SP_6_Manual&Tag=CM_SP_7_Manual";
	$inputTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
	$macAddressAndLights="http://192.168.1.1/read_data.xml?Cmd=read&Tag=MAC_Address&Tag=Programmed_Lights_On";
	$alarms="http://192.168.1.1/alarm_status.xml?Cmd=read&Item=menu";
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $inputNames);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$inputNames=inputNames(curl_exec($ch));
	curl_setopt($ch, CURLOPT_URL, $inputPVs);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$debug=curl_exec($ch);
	$filterPVs=strpos($debug,'Idle');
	$inputPVs=inputPVs($debug);
	curl_setopt($ch, CURLOPT_URL, $inputSPs);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$debug=curl_exec($ch);
	$filterSPs=strpos($debug,'Idle');
	$inputSPs=inputSPs($debug);
	curl_setopt($ch, CURLOPT_URL, $inputTags);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$inputTags=inputCheck(curl_exec($ch));
	curl_setopt($ch, CURLOPT_URL, $macAddressAndLights);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$macAddressAndLights=macAddressAndLights(curl_exec($ch));
	curl_setopt($ch, CURLOPT_URL, $alarms);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$alarmStatus=alarmStatus(curl_exec($ch));
	curl_close($ch);

        if(($filterPVs==false)&&($filterSPs==false)) {

	$string="Chamber status update.\n";
	$string="Chamber {$macAddressAndLights[0]} Status.\n";
	if($alarmStatus) {
		$string.="Alarm is active on chamber.\n";
	};
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$string.="{$inputNames[$i]} Status\nPV/SP: {$inputPVs[$i]}/{$inputSPs[$i]}\n";
		};
	};
	if($macAddressAndLights[1]=='0') {
		$string.="All lights are off.\n";
	} else {
		$string.="Lights are on.\n";
	};
	$message=$string;
	//MESSAGE FOR E-MAIL HAS BEEN MADE.

    //Let's make the graph data.
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
            $fname="{$i}PV.txt";
            //Delete first line of graph data file.
            shell_exec("sed -i.bak 's/^[^}]*},//' {$i}PV.txt");
            //Add the current datapoint
            $tempTime=time();
            $step="{x: ".$tempTime.", y:".$inputPVs[$i].",},";
	    file_put_contents($fname,trim($step),FILE_APPEND);
            shell_exec("tr '\n' ' ' <{$i}PV.txt > temp.txt && mv temp.txt {$i}PV.txt");
            $fname="{$i}SP.txt";
            shell_exec("sed -i.bak 's/^[^}]*},//' {$i}SP.txt");
            $tempTime=time();
            $step="{x: ".$tempTime.", y:".$inputSPs[$i].",},";
	    file_put_contents($fname,trim($step),FILE_APPEND);
            shell_exec("tr '\n' ' ' <{$i}SP.txt > temp.txt && mv temp.txt {$i}SP.txt");
            if($inputPVs[0]==0) {
                $fname="debugzerovalue.txt";
                $nfile=fopen($fname, "w");
                if($nfile != false) { 
                    fwrite($nfile,$debug);
                    fclose($nfile);
                };
            };
        };
    };
		

	//Set up e-mail credentials.
	if($type=="na"&&$username=="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port);
	} else if($type=="na"&&$username!="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port)
		  ->setUsername("{$username}")
		  ->setPassword("{$password}");
	} else if($type!="na"&&$username=="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port,$type);
	} else if($type!="na"&&$username!="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port,$type)
		  ->setUsername("{$username}")
		  ->setPassword("{$password}");
	};
	$mailer = Swift_Mailer::newInstance($transport);
	//Find out current minute
	$time=60*date('H')+date('i');
	//Get array of minutes to send out mail.
	$min=2000;
	$sendingArray=array();
	$sendingArray[]=$initial*60;
	while (($sendingArray[sizeof($sendingArray)-1]+$frequency)%1440!=$sendingArray[0]) {
		$nextMinute=($sendingArray[sizeof($sendingArray)-1]+$frequency)%1440;
		$sendingArray[]=$nextMinute;
		$mod=($time-$nextMinute)%1440;
		if($mod<0) {
			$mod+=1440;
		};
		if($min!=min($min,$mod)) {
			$newLast=$nextMinute;
		};
		$min=min($min,$mod);
	};
	//Check if message should be sent out.
	if($newLast!=$last) {
		//Alright send out the message.
		$fname="debugger.txt";
		$e=0;
		$nfile = fopen($fname, "w");
		if($nfile != false) { 
			fwrite($nfile,"2");
			fclose($nfile);
		};
		try {
			$mailingList=array_filter(array($email1,$email2,$email3,$email4));
			$message = Swift_Message::newInstance('INTELLUS STATUS UPDATE')
			  ->setFrom(array('intellus@controller.com' => 'INTELLUS'))
			  ->setTo($mailingList)
			  ->setBody($string);
			$result = $mailer->send($message);
var_dump($string);
var_dump($mailingList);
var_dump($result);
			print("Test message successfully sent.");
		} catch(Exception $e) {
			echo 'Caught exception', $e->getMessage(), "\n";
			print("Bad network connection?");
		};
		//overwrite $last with $newLast to make sure this doesn't repeat too much.
		$filename = "last.txt";
		$handle = fopen($filename, "w");
		$last= fwrite($handle, $newLast);
		fclose($handle);
	};

	$fname="debugger.txt";
	$nfile = fopen($fname, "w");
	if($nfile != false) { 
		fwrite($nfile,"4,{$frequency}");
		fclose($nfile);
	};

	}; //Ending if catch of Idle.

};
?>
