<html>
	<head>
		<title>E-mail Sent</title>
		<style>
			i {
				color:black;
			}
			body {
				font-family: 'Calibri',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 14px;
				color: #6F6D6D;
				margin-left:10vw;
			}
			input {
				width:8em;
				font-family: 'ArialMT','Arial',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.textField {
				border-radius: 4px;
				border-color: #FFFFFF;
				box-shadow: 1px 1px 0px #6F6D6D;
			}
			.forceRight {
				float:right;
			}
			.hideme {
				display:none;
				visibility:hidden;
			}
			.save {
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			.tdelement {
				background-color: #FFF;
				padding:8px;
				margin: 0.125em 0.25em 0.125em 0.25em;
				border-radius: 4px;
			}
			.demo {
				width: 80vw;
				border-right: solid #ffffff 5vw;
				border-left: solid #ffffff 5vw;
			}
			.demo2 {
				width: 80vw;
				border-right: solid #f7f7f7 5vw;
				border-left: solid #f7f7f7 5vw;
			}
			.peach{
				background-color:#f7f7f7;
			}
			.input-name {
				color:#7f7e7e;
				font-family:'Calibri',sans-serif;
				text-align: left;
				line-height: normal;
				letter-spacing:1.3px;
				box-sizing:border-box;
				font-size: 12px;
			}
			.input-pv {
				color:#4d627b;
				font-family:'Arial Regular', 'Arial',sans-serif;
				font-weight: 700;
				font-size: 46px;
				text-align: left;
				line-height: normal;
			}
			.right-side {
				padding-right: 10vw;
				border-right: 1px solid #0078c1;
			}
			.circleText {
				position: relative;
				color: #4d627b;
				left:15px;
				top:55px;
				font-family:'Arial Regular', 'Arial',sans-serif;
				font-weight: 700;
				font-size: 23px;
			};
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="glider.js"></script>
		<script src="circle-progress.js"></script>
		<link rel="stylesheet"  type="text/css" href="glider.css">
		<link rel="stylesheet"  type="text/css" href="toggle-switch.css">
		<script>
		</script>
	</head>
	<body>
<?php
ini_set("display_errors",1);
error_reporting(E_ALL);
require_once 'lib/swift_required.php';

include 'lhs.php';
echo LHS('dashboard');
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function macAddressAndLights($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<2;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function alarmStatus($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$alarmStatus=0;
	foreach($matches as $i=>$match) {
		if(substr($match,1,-2)!="Off"&&$i>1) {
			$alarmStatus=1;
		}
	};
	return $alarmStatus;
}
function inputPVs($string) {
	preg_match_all("/PV_[0-9]>[^<]+<\/PV_[0-9]/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],5,-6);
	};
	return $input;
}
function inputSPs($string) {
	preg_match_all("/Manual>[^<]+<\/CM_SP_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],7,-8);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function outputDim($string) {
	preg_match_all("/Dim>[^<]+<\/EO_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=(float)substr($matches[$i],4,-5);
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO) {
	$str.="<tr><td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$i]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField'></div></td>";
		};
	};
	for($i=0;$i<5;$i++) {
		for($j=0;$j<count($outputCheck[$i]);$j++) {
			$num=$i*10+$j+1;
			if($outputCheck[$i][$j]==1) {
				if(isset($EO[$num])) {
					if($EO[$num]==="ON"||$EO[$num]===100||$EO[$num]==="100") {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON' selected>ON</option><option value='OFF'>OFF</option></select></div></td>";
					} else {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
					};
				} else {
					$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
				};
				$eolist[]=$num;
			} else if($outputCheck[$i][$j]==2) {
				$eolist[]=$num;
				$str.="<td><div class='tdelement'>Dimm % $num<input name='EO{$num}[]' type='number' value='".$EO[$num]."' min='0' max='100' step='0.1' class='forceRight textField'></div></td>";
			};
		};
	};
	$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

//GRAB CONTROLLER DATA TO CORRECTLY SET UP Dashboard.
$inputNames="http://192.168.1.1/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputPVs="http://192.168.1.1/read_data.xml?Cmd=read&Tag=PV_1&Tag=PV_2&Tag=PV_3&Tag=PV_4&Tag=PV_5&Tag=PV_6&Tag=PV_7";
$inputSPs="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CM_SP_1_Manual&Tag=CM_SP_2_Manual&Tag=CM_SP_3_Manual&Tag=CM_SP_4_Manual&Tag=CM_SP_5_Manual&Tag=CM_SP_6_Manual&Tag=CM_SP_7_Manual";
$inputTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$macAddressAndLights="http://192.168.1.1/read_data.xml?Cmd=read&Tag=MAC_Address&Tag=Programmed_Lights_On";
$alarms="http://192.168.1.1/alarm_status.xml?Cmd=read&Item=menu";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $inputNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputPVs);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputPVs=inputPVs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputSPs);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputSPs=inputSPs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputTags=inputCheck(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $macAddressAndLights);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$macAddressAndLights=macAddressAndLights(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $alarms);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$alarmStatus=alarmStatus(curl_exec($ch));
curl_close($ch);
$string="Chamber status update.\n";
$string="Chamber {$macAddressAndLights[0]} Status.\n";
if($alarmStatus) {
	$string.="Alarm is active on chamber.\n";
};
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		$string.="{$inputNames[$i]} Status\nPV/SP: {$inputPVs[$i]}/{$inputSPs[$i]}\n";
	};
};
if($macAddressAndLights[1]=='0') {
	$string.="All lights are off.\n";
} else {
	$string.="Lights are on.\n";
};


$posted = &$_POST;
$smtp = $posted["SMTP"];
$port = $posted["port"];
$username = $posted["username"];
$password = $posted["password"];
$frequency = $posted["frequency"];
$type = $posted["type"];
$initial = $posted["initial"];
$email1 = $posted["email1"];
$email2 = $posted["email2"];
$email3 = $posted["email3"];
$email4 = $posted["email4"];
/*
$posted['action']="Send Test E-mail";
$smtp="10.1.1.119";
$port="25";
$username="";
$password="!";
$frequency="60";
$type="na";
$initial="9";
$email1="@percival-scientific.com";
$email2="";
$email3="";
$email4="";
*/
if($posted['action']=="Send Test E-mail") {
	//Set up e-mail credentials.
	if($type=="na"&&$username=="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port);
	} else if($type=="na"&&$username!="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port)
		  ->setUsername("{$username}")
		  ->setPassword("{$password}");
	} else if($type!="na"&&$username=="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port,$type);
	} else if($type!="na"&&$username!="") {
		$transport = Swift_SmtpTransport::newInstance($smtp,$port,$type)
		  ->setUsername("{$username}")
		  ->setPassword("{$password}");
	};
	$mailer = Swift_Mailer::newInstance($transport);
	//Initialize a few variables
	$timeout=5;
	$messageSent=0;
	$fname="debugger.txt";
	$nfile = fopen($fname, "w");
	if($nfile != false) { 
		fwrite($nfile,"2t");
		fclose($nfile);
	};
	try{
		$mailingList=array_filter(array($email1,$email2,$email3,$email4));
		$message = Swift_Message::newInstance('INTELLUS STATUS UPDATE')
		  ->setFrom(array('intellus@controller.com' => 'INTELLUS'))
		  ->setTo($mailingList)
		  ->setBody($string);
		$result = $mailer->send($message);
		$messageSent=1;
/*
var_dump($string);
var_dump($mailingList);
var_dump($result);
*/
		print("Test Message successfully sent.");
	} catch(Exception $e) {
		echo 'Caught exception', $e->getMessage(), "\n";
		//Setting this to 0 will ensure we will return to this and trying emailing again in a minute.
		$messageSent=0;
		print("There was a bad network connection, trying again while increasing timeout, ignore previous error messages...");
	};
	sleep($timeout);
	$timeout=$timeout+5;
	$fname="debugger.txt";
	$nfile = fopen($fname, "w");
	if($nfile != false) { 
		fwrite($nfile,"3t");
		fclose($nfile);
	};
} else {
	//To keep track of running emailer task.
	$fname="frequency.txt";
	$nfile = fopen($fname, "w");
	if($nfile != false) { 
		//fwrite($nfile,"{$frequency}");
		fwrite($nfile,"{$username},{$password},{$frequency},{$initial},{$email1},{$email2},{$email3},{$email4},{$smtp},{$port},{$type}");
		fclose($nfile);
	};
	//The script is ran as part of the runlogger script cron job.
	//$WshShell = new COM("WScript.Shell");
	//$oExec = $WshShell->Run("php\php-win.exe -f backgroundProcess.php {$username},{$password},{$frequency},{$initial},{$email1},{$email2},{$email3},{$email4},{$smtp},{$port}", 0, false);

	//This is so we can allow the background process to properly close before running a new one.
	//sleep(5); 
	print("Email process started.");
};
print("<BR><a href='email.php'>Go back</a>");
?>
</body>
</html>
