<?php
include 'credentialCheck.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="refresh" content="60; url="dashboard.php">
		<title>Intellus Dashboard</title>
		<style>
			i {
				color:black;
			}
			body {
				font-family: 'Calibri',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 14px;
				color: #6F6D6D;
				margin-left:10vw!important;
			}
			input {
				width:8em;
				font-family: 'ArialMT','Arial',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.textField {
				border-radius: 4px;
				border-color: #FFFFFF;
				box-shadow: 1px 1px 0px #6F6D6D;
			}
			.forceRight {
				float:right;
			}
			.hideme {
				display:none;
				visibility:hidden;
			}
			.save {
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			.tdelement {
				background-color: #FFF;
				padding:8px;
				margin: 0.125em 0.25em 0.125em 0.25em;
				border-radius: 4px;
			}
			.demo {
				width: 80vw;
				border-right: solid #ffffff 5vw;
				border-left: solid #ffffff 5vw;
			}
			.demo2 {
				width: 80vw;
				border-right: solid #f7f7f7 5vw;
				border-left: solid #f7f7f7 5vw;
			}
			.peach{
				background-color:#f7f7f7;
			}
			.input-name {
				color:#7f7e7e;
				font-family:'Calibri',sans-serif;
				text-align: left;
				line-height: normal;
				letter-spacing:1.3px;
				box-sizing:border-box;
				font-size: 12px;
			}
			.input-pv {
				color:#4d627b;
				font-family:'Arial Regular', 'Arial',sans-serif;
				font-weight: 700;
				font-size: 46px;
				text-align: left;
				line-height: normal;
			}
			.right-side {
				padding-right: 10vw;
				border-right: 1px solid #0078c1;
			}
			.circleText {
				position: relative;
				color: #4d627b;
				left:15px;
				top:55px;
				font-family:'Arial Regular', 'Arial',sans-serif;
				font-weight: 700;
				font-size: 23px;
			};
		</style>
		<script src="jquery-3.6.0.js"></script>
		<script src="jquery-ui.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="glider.js"></script>
		<script src="circle-progress.js"></script>
		<script src="jquery.modal.min.js"></script>
		<link rel="stylesheet"  type="text/css" href="normalize.css">
		<link rel="stylesheet"  type="text/css" href="jquery.modal.min.css">
		<link rel="stylesheet"  type="text/css" href="glider.css">
		<link rel="stylesheet"  type="text/css" href="toggle-switch.css">
		<link rel="stylesheet" href="jquery-ui.css">
		<link rel="stylesheet" href="rickshaw.css">
		<script src="d3.min.js"></script>
		<script src="rickshaw.js"></script>
	</head>
	<body>
<?php
include 'lhs.php';
echo LHS('dashboard');
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function inputPVs($string) {
	preg_match_all("/PV_[0-9]>[^<]+<\/PV_[0-9]/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],5,-6);
	};
	return $input;
}
function inputSPs($string) {
	preg_match_all("/SP_[0-9]>[^<]+<\/SP_[0-9]/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) substr($matches[$i],5,-6);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function outputDim($string) {
	preg_match_all("/Dim>[^<]+<\/EO_/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=(float)substr($matches[$i],4,-5);
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function alarms($string) {
	preg_match_all("/<[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$alarmStatus=0;
	$alarms=[];
	foreach($matches as $i=>$match) {
		if($i>1) {
			$alarm=explode('<',$match);
			$alarm=explode('>',$alarm[1]);
			$alarms[$alarm[0]]=$alarm[1];
		};
	};
	return $alarms;
}
function alarmStatus($alarms) {
	$alarmStatus=0;
	foreach($alarms as $alarm) {
		if($alarm[1]!="Off") {
			if(substr($alarm[1],1,-2)=="Silenced"&&$alarmStatus!=1) {
				$alarmStatus=2;
			} else {
				$alarmStatus=1;
			};
		};
	};
	return $alarmStatus;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO) {
	$str.="<tr><td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$i]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField'></div></td>";
		};
	};
	for($i=0;$i<5;$i++) {
		for($j=0;$j<count($outputCheck[$i]);$j++) {
			$num=$i*10+$j+1;
			if($outputCheck[$i][$j]==1) {
				if(isset($EO[$num])) {
					if($EO[$num]==="ON"||$EO[$num]===100||$EO[$num]==="100") {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON' selected>ON</option><option value='OFF'>OFF</option></select></div></td>";
					} else {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
					};
				} else {
					$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
				};
				$eolist[]=$num;
			} else if($outputCheck[$i][$j]==2) {
				$eolist[]=$num;
				$str.="<td><div class='tdelement'>Dimm % $num<input name='EO{$num}[]' type='number' value='".$EO[$num]."' min='0' max='100' step='0.1' class='forceRight textField'></div></td>";
			};
		};
	};
	$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

//GRAB CONTROLLER DATA TO CORRECTLY SET UP Dashboard.
$ngip="https://127.0.0.2";
$inputNames=$ngip."/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputDecimal=$ngip."/read_data.xml?Cmd=read&Tag=AI_Decimal_1&Tag=AI_Decimal_2&Tag=AI_Decimal_3&Tag=AI_Decimal_4&Tag=AI_Decimal_5&Tag=AI_Decimal_6&Tag=AI_Decimal_7";
$inputPVs=$ngip."/read_data.xml?Cmd=read&Tag=PV_1&Tag=PV_2&Tag=PV_3&Tag=PV_4&Tag=PV_5&Tag=PV_6&Tag=PV_7";
//$inputSPs=$ngip."/read_data.xml?Cmd=read&Tag=CM_SP_1_Manual&Tag=CM_SP_2_Manual&Tag=CM_SP_3_Manual&Tag=CM_SP_4_Manual&Tag=CM_SP_5_Manual&Tag=CM_SP_6_Manual&Tag=CM_SP_7_Manual";
$inputSPs=$ngip."/read_data.xml?Cmd=read&Tag=SP_1&Tag=SP_2&Tag=SP_3&Tag=SP_4&Tag=SP_5&Tag=SP_6&Tag=SP_7";
$inputTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$outputTags[0]=$ngip."/read_data.xml?Cmd=read&Tag=DO_Function_1&Tag=DO_Function_2&Tag=DO_Function_3&Tag=DO_Function_4&Tag=DO_Function_5&Tag=DO_Function_6&Tag=DO_Function_7&Tag=DO_Function_8&Tag=DO_Function_9&Tag=DO_Function_10";
$outputTags[1]=$ngip."/read_data.xml?Cmd=read&Tag=DO_Function_11&Tag=DO_Function_12&Tag=DO_Function_13&Tag=DO_Function_14&Tag=DO_Function_15&Tag=DO_Function_16&Tag=DO_Function_17&Tag=DO_Function_18&Tag=DO_Function_19&Tag=DO_Function_20";
$outputTags[2]=$ngip."/read_data.xml?Cmd=read&Tag=DO_Function_21&Tag=DO_Function_22&Tag=DO_Function_23&Tag=DO_Function_24&Tag=DO_Function_25&Tag=DO_Function_26&Tag=DO_Function_27&Tag=DO_Function_28&Tag=DO_Function_29&Tag=DO_Function_30";
$outputTags[3]=$ngip."/read_data.xml?Cmd=read&Tag=DO_Function_31&Tag=DO_Function_32&Tag=DO_Function_33&Tag=DO_Function_34&Tag=DO_Function_35&Tag=DO_Function_36&Tag=DO_Function_37&Tag=DO_Function_38&Tag=DO_Function_39&Tag=DO_Function_40";
$outputTags[4]=$ngip."/read_data.xml?Cmd=read&Tag=DO_Function_41&Tag=DO_Function_42&Tag=DO_Function_43&Tag=DO_Function_44&Tag=DO_Function_45&Tag=DO_Function_46&Tag=DO_Function_47";
$outputLevels[0]=$ngip."/read_data.xml?Cmd=read&Tag=EO_1_Dim&Tag=EO_2_Dim&Tag=EO_3_Dim&Tag=EO_4_Dim&Tag=EO_5_Dim&Tag=EO_6_Dim&Tag=EO_7_Dim&Tag=EO_8_Dim&Tag=EO_9_Dim&Tag=EO_10_Dim";
$outputLevels[1]=$ngip."/read_data.xml?Cmd=read&Tag=EO_11_Dim&Tag=EO_12_Dim&Tag=EO_13_Dim&Tag=EO_14_Dim&Tag=EO_15_Dim&Tag=EO_16_Dim&Tag=EO_17_Dim&Tag=EO_18_Dim&Tag=EO_19_Dim&Tag=EO_20_Dim";
$outputLevels[2]=$ngip."/read_data.xml?Cmd=read&Tag=EO_21_Dim&Tag=EO_22_Dim&Tag=EO_23_Dim&Tag=EO_24_Dim&Tag=EO_25_Dim&Tag=EO_26_Dim&Tag=EO_27_Dim&Tag=EO_28_Dim&Tag=EO_29_Dim&Tag=EO_30_Dim";
$outputLevels[3]=$ngip."/read_data.xml?Cmd=read&Tag=EO_31_Dim&Tag=EO_32_Dim&Tag=EO_33_Dim&Tag=EO_34_Dim&Tag=EO_35_Dim&Tag=EO_36_Dim&Tag=EO_37_Dim&Tag=EO_38_Dim&Tag=EO_39_Dim&Tag=EO_40_Dim";
$outputLevels[4]=$ngip."/read_data.xml?Cmd=read&Tag=EO_41_Dim&Tag=EO_42_Dim&Tag=EO_43_Dim&Tag=EO_44_Dim&Tag=EO_45_Dim&Tag=EO_46_Dim&Tag=EO_47_Dim";
$highRangeTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_SP_High_1&Tag=CLC_SP_High_2&Tag=CLC_SP_High_3&Tag=CLC_SP_High_4&Tag=CLC_SP_High_5&Tag=CLC_SP_High_6&Tag=CLC_SP_High_7";
$lowRangeTags=$ngip."/read_data.xml?Cmd=read&Tag=CLC_SP_Low_1&Tag=CLC_SP_Low_2&Tag=CLC_SP_Low_3&Tag=CLC_SP_Low_4&Tag=CLC_SP_Low_5&Tag=CLC_SP_Low_6&Tag=CLC_SP_Low_7";
$alarms=$ngip."/alarm_status.xml?Cmd=read&Item=menu";
$status=$ngip."/read_data.xml?Cmd=read&Tag=UI_Current_Info&Tag=Real_Time_Hour&Tag=Real_Time_Minute";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $inputNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputDecimal);
$inputDecimal=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputPVs);
$inputPVs=inputPVs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputSPs);
$inputSPs=inputSPs(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highRangeTags);
$highRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowRangeTags);
$lowRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputTags);
$inputTags=inputCheck(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $status);
$status=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $alarms);
$alarms=alarms(curl_exec($ch));
$alarmStatus=alarmStatus($alarms);


//START WRITING THE ACTUAL PAGE GIVEN CONTROLLER DATA.
$str="";
//Writing the Inputs...
$str.="<div class='demo'>";
$str.="<div class='glider-contain'>";
$str.="<div class='input-glider'>";
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		$str.="<div>";
		$str.="<div class='input-name'>".$inputNames[$i]."</div><BR>";
        if($inputDecimal[$i]==="0.0") {
            $digits=1;
        } else {
            $digits=0;
        };
        $value=number_format($inputPVs[$i],$digits);
		if($i==0) {
		$str.="<table class='right-side'><tr><td><img src='netgateAssets/tempIcon.png'></td><td class='input-pv'>".$value.$inputTags[$i]."</td></tr>";
		} elseif($i==1) {
		$str.="<table class='right-side'><tr><td><img src='netgateAssets/RHIcon.png'></td><td class='input-pv'>".$value.$inputTags[$i]."</td></tr>";
		} else {
		$str.="<table class='right-side'><tr><td><img src='netgateAssets/elseIcon.png'></td><td class='input-pv'>".$value.$inputTags[$i]."</td></tr>";
		};
		$pvPercent=round(100*((float) ($inputPVs[$i])-(float) ($lowRangeTags[$i]))/((float) ($highRangeTags[$i])-(float) ($lowRangeTags[$i])));
		$spPercent=round(100*((float) ($inputSPs[$i])-(float) ($lowRangeTags[$i]))/((float) ($highRangeTags[$i])-(float) ($lowRangeTags[$i])));
		//$str.="<tr><td></td><td><progress max='100' value='".$pvPercent."'></progress><BR><progress max='100' value='".$spPercent."'></progress></td></tr></table>";
        $value=number_format($inputSPs[$i],$digits);
		$str.="<tr><td></td><td> SP:".$value.$inputTags[$i]."</td></tr></table>";
		$str.="</div>";
	};
};
$str.="</div>";
$str.="  <button aria-label='Previous' id='input-glider-prev' class='glider-prev'>&lt;</button>";
$str.="  <button aria-label='Next' id='input-glider-next' class='glider-next'>&gt;</button>";
$str.="</div>";
$str.="</div>";
//Writing the Outputs...
$str.="<div class='demo2 peach'>";
$str.="<div class='glider-contain'>";
$str.="<div class='output-glider'>";
//Stop, grab outputs.
$eolist=[];
for($i=0;$i<5;$i++) {
	curl_setopt($ch, CURLOPT_URL, $outputTags[$i]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$outputCheck[$i]=outputCheck(curl_exec($ch));
	curl_setopt($ch, CURLOPT_URL, $outputLevels[$i]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$outputDim[$i]=outputDim(curl_exec($ch));
	for($j=0;$j<count($outputCheck[$i]);$j++) {
		$num=$i*10+$j+1;
		if($outputCheck[$i][$j]) {
			$str.="<div>";
			if($outputCheck[$i][$j]==1) {
				if($outputDim[$i][$j]>0) {
					$str.="<BR>Event ".$num."<label class='switch-light switch-material'><input type='checkbox' checked disabled/><span><span>Off</span><span>On</span><a></a></span></label><BR>ON<BR>";
				} else {
					$str.="<BR>Event ".$num."<label class='switch-light switch-material'><input type='checkbox' disabled/><span><span>Off</span><span>On</span><a></a></span></label><BR>OFF<BR>";
				};
			} elseif($outputCheck[$i][$j]==2) {
				$display=100*$outputDim[$i][$j]/10000; 
				$level=99*$outputDim[$i][$j]/1000000; //I need that as 99 instead of 100 to display a small open sliver in the UI in the case of 100% lights on.  it's a graphical tearing thing.
				$str.="<div class='circleText'>".$display."%</div><div id='circle$i$j' class='output-name'></div><BR>";

				$str.="<script>";
				$str.="$('#circle$i$j').circleProgress({value:$level,size:80,fill: {color: '#159894'},emptyFill:'#f7f7f7' });";
				$str.="</script>";
				$str.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Event $num<BR>";
			};
			$str.="</div>";
			$eolist[]=$num;
		};
	};
};
$str.="</div>";
$str.="  <button aria-label='Previous' id='output-glider-prev' class='glider-prev peach'>&lt;</button>";
$str.="  <button aria-label='Next' id='output-glider-next' class='glider-next peach'>&gt;</button>";
$str.="</div>";
$str.="</div>";
echo $str;
$str="<script>";
$str.="window.addEventListener('load', function(){";
$str.="  var inputGlider = new Glider(document.querySelector('.input-glider'), {";
$str.="    slidesToScroll: 3,";
$str.="    slidesToShow: 2.5,";
$str.="    draggable: true,";
$str.="    arrows: { prev: '#input-glider-prev', next: '#input-glider-next' }";
$str.="  });";
$str.="  var outputGlider = new Glider(document.querySelector('.output-glider'), {";
$str.="    slidesToScroll: 8,";
$str.="    slidesToShow: 5,";
$str.="    draggable: true,";
$str.="    arrows: { prev: '#output-glider-prev', next: '#output-glider-next' }";
$str.="  });";
$str.="})";
$str.="</script>";
//Rickshaw graph placeholder.
$str.="<form action='dashboard.php' method='post' enctype='multipart/form-data'>";
$str.="<select name='input'>";
if(isset($_POST['input'])) {
    for($i=0;$i<7;$i++) {
        if($inputTags[$i]) {
            if($_POST['input']==$i) {
                $str.="<option value='$i' selected>".$inputNames[$i]."</option>";
                $graphPV=file_get_contents("{$i}PV.txt");
                $graphSP=file_get_contents("{$i}SP.txt");
		$currentInput=$inputNames[$i];
            } else {
                $str.="<option value='$i'>".$inputNames[$i]."</option>";
            };
        };
    };
} else {
    $str.="<option value='0' selected>".$inputNames[0]."</option>";
    $graphPV=file_get_contents("0PV.txt");
    $graphSP=file_get_contents("0SP.txt");
    $currentInput=$inputNames[0];
    for($i=1;$i<7;$i++) {
        if($inputTags[$i]) {
            $str.="<option value='$i'>".$inputNames[$i]."</option>";
        };
    };
};
$str.="</select>";
$str.="<input type='submit' value='Grab Graph' class='save'>";
$str.="</form>";
$str.="<div style='margin-bottom:10px; margin-left:20px' id='mylegend'></div>";
$str.="  <div style='display:block; float:left; width:20px; height:280px; padding-bottom:10px;' id='yaxis'></div>";
$str.="  <div>";
$str.="  <div style='margin-left:20px;' id='mychart'></div>";
$str.="  <div style='margin-left:20px' id='xaxis'></div>";
$str.="  <div style='margin-left:20px' id='previewSlider'></div>";
$str.="  </div>";
//Generate Alarms modal.
	$str.="<div id='alarmsModal' class='modal'>";
	$str.="<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' aria-hidden='true' role='img' width='10em' height='10em' preserveAspectRatio='xMidYMid meet' viewBox='0 0 896 1024'><path d='M842 712l-20-25l-19.5-26l-19-29.5l-15-30l-11.5-33l-4-31.5V328q0-67-24-127.5t-64.5-104T567 27T446 1q-84 0-154.5 44T181 164t-40 164v209q0 18-5 36.5t-18 40t-20 32T72 681t-22 28l-18 25.5l-14 22l-10.5 22L5 798l5 21q17 33 83 33h183q0 71 50 121t121 50t121-50t50-121h187q66 0 81-33q4-7 4.5-14.5t0-13.5t-4.5-14.5t-7-14.5t-10.5-16t-12.5-16t-14-18zM447 956q-21 0-40-8.5t-33-22t-22.5-33T343 852h208q0 43-30.5 73.5T447 956zm358-172H81q6-10 24-34q1-2 20-27t25-33t21-32.5t20.5-39.5t11.5-38t6-43V328q0-108 68.5-183.5T446 69q29 0 56 7t50.5 19.5t44 30.5t37 40.5t28 47.5t17.5 54t6 60v209q0 31 9 62.5t27.5 61.5t32 48.5T789 755l4.5 6l4.5 5.5l5 6l4.5 5.5l4.5 6h-7z' fill='#3f796b'/></svg><BR><BR>";

	$str.="<div id='alarmsIndication'>";
	$str.="</div>";
	$str.="</div>";
//End Alarms modal.
//	echo $str;

	//Activate Rickshaw graph.
$str.="	<script>";
$str.="  var myGraph = new Rickshaw.Graph({";
$str.="    element: document.querySelector(\"#mychart\"),";
$str.="    width: 500,";
$str.="    height: 250,";
$str.="    min: 0,";
$str.="    max: 100,";
$str.="    renderer: 'line',";
$str.="    series: [ ";
$str.="    {";
$str.="      name: \"".$currentInput." PV\",";
$str.="      color: \"steelblue\",";
$str.="      data: [".$graphPV;
//$str.="      {x: 0, y:10,},{x: 1, y:3,},{x: 2, y:8,},{x: 3, y:15,},{x: 4, y:12,},";
//$str.="      {x: 5, y:8,},{x: 6, y:3,},{x: 7, y:5,},{x: 8, y:2,},{x: 9, y:1,},{x: 10, y:4,},";
$str.="      ]";
$str.="    },";
$str.="    {";
$str.="      name: \"".$currentInput." SP\",";
$str.="      color: \"green\",";
$str.="      data: [".$graphSP;
//$str.="      {x: 0, y:5,},{x: 1, y:3,},{x: 2, y:8,},{x: 3, y:6,},{x: 4, y:3,},";
//$str.="      {x: 5, y:12,},{x: 6, y:13,},{x: 7, y:14,},{x: 8, y:12,},{x: 9, y:8,},{x: 10, y:9,},";
$str.="      ]";
$str.="    }";
$str.="    ]";
$str.="  });";
$str.="  var xTicks = new Rickshaw.Graph.Axis.Time({";
$str.="    graph:myGraph,";
$str.="    orientation: \"bottom\",";
$str.="    element: document.querySelector(\"#xaxis\")";
$str.="  });";
$str.="  var yTicks = new Rickshaw.Graph.Axis.Y({";
$str.="    graph:myGraph,";
$str.="    orientation: \"left\",";
$str.="    element: document.querySelector(\"#yaxis\")";
$str.="  });";
$str.="  var graphHover = new Rickshaw.Graph.HoverDetail({";
$str.="    graph:myGraph";
$str.="  });";
$str.="  var myLegend = new Rickshaw.Graph.Legend({";
$str.="    graph:myGraph,";
$str.="    element: document.querySelector(\"#mylegend\")";
$str.="  });";
$str.="  var previewSlider = new Rickshaw.Graph.RangeSlider.Preview({";
$str.="    graph: myGraph,";
$str.="    element: document.querySelector(\"#previewSlider\")";
$str.="  });";
$str.="  myGraph.render();";
$str.="</script>";
echo $str;

curl_close($ch);
//$ip=gethostbyname(gethostname());
//echo $ip;
?>
<script>
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	};
	});
setInterval(function(){
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	} else {
		$.modal.close();
	};
	});
},60000);
</script>
	</body>
</html>

