<?php
include 'credentialCheck.php';
?>
<!DOCTYPE html>
<html>
	<head>
		<title>Program Maker</title>
		<style>
			body {
				font-family: 'Calibri',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 14px;
				color: #6F6D6D;
				margin-left:10vw;
			}
			table {
				display: table;
				border-spacing: 1em 1em;
			}
			table tr {
				background-color: #F7F7F7;
				display: table-cell;
				box-shadow: 2px 2px 2px 2px rgb(0,0,0,35%);
				border-radius: 4px;
			}
			table tr td {
				display: block;
				background-clip: content-box;
			}
			th {
				height:100%;
				width:100%;
				display: block;
				background-clip: content-box;
			}
			input {
				width:8em;
				font-family: 'ArialMT','Arial',sans-serif;
				font-weight: 400;
				font-style: normal;
				font-size: 13px;
				color: #000000;
				text-align:left;
			}
			.textField {
				border-radius: 4px;
				border-color: #FFFFFF;
				box-shadow: 1px 1px 0px #6F6D6D;
			}
			.forceRight {
				float:right;
			}
			.hideme {
				display:none;
				visibility:hidden;
			}
			.save {
				background-color: rgba(0,120,193,1);
				border-radius:5px;
				border:none;
				font-family: 'NotoSans-Bold','Noto Sans Bold', 'Noto Sans',sans-serif;
				font-weight: 700;
				font-style: normal;
				color:#FFFFFF;
				padding:4px 4px 4px 4px;
				margin:8px;
				text-align:center;
				text-decoration:none;
			}
			.tdelement {
				background-color: #FFF;
				padding:8px;
				margin: 0.125em 0.25em 0.125em 0.25em;
				border-radius: 4px;
			}
		</style>
		<script src="jquery-1.12.4.js"></script>
		<script src="jquery-sortElements.js"></script>
		<script src="sort-table.js"></script>
		<script src="jquery.modal.min.js"></script>
		<link rel="stylesheet"  type="text/css" href="jquery.modal.min.css">
		<script>
//Manual sort button if you click on the 'time' th label...this block is not needed given that those labels have been force hidden by css magic, but is nice for debugging and troubleshooting.
function sortTable() {
	var table = $('#program');
	$('#time')
	    .wrapInner('<span title="sort this column"/>')
	    .each(function(){

		var th = $(this),
		    thIndex = th.index(),
		    inverse = false;

		th.click(function(){


		    table.find('input').filter(function(){

			return $(this).index() === thIndex;

		    }).sortElements(function(a, b){
			    a=a.value;
			    b=b.value;
	    console.log(a);
	    console.log(b);
			    //console.log(a>b)

			if( a==b )//$.text([a]) == $.text([b]) )
			    return 0;

			return a > b ?//$.text([a]) > $.text([b]) ?
			    inverse ? -1 : 1
			    : inverse ? 1 : -1;

		    }, function(){

			// parentNode is the element we want to move
			return this.parentNode.parentNode.parentNode; 

		    });

		    inverse = !inverse;

		});

	    });
};

//Correctly sort programming blocks to keep them in chronological order.
function postSort() {
    var table = $('#program');
    $('#time').each(function(){
    var th = $(this),
    thIndex = th.index(),
    inverse = false;

    table.find('input').filter(function(){

	return $(this).index() === thIndex;

    }).sortElements(function(a, b){
	    a=a.value;
	    b=b.value;
	    //console.log(a>b)

	if( a==b )//$.text([a]) == $.text([b]) )
	    return 0;

	return a > b ?//$.text([a]) > $.text([b]) ?
	    inverse ? -1 : 1
	    : inverse ? 1 : -1;

    }, function(){

	// parentNode is the element we want to move
	return this.parentNode.parentNode.parentNode; 

    });

    inverse = !inverse;
    });
}

			//Insert new block step.
			$( function() {
			 $('#ins').click(function () {
			     $("#program").each(function () {
				 var tds = '<tr>';
				 var num = 1;
				 var counter=0;
				 jQuery.each($('tr:last td', this), function () {
					 tds += '<td>' + $(this).html() + '</td>';
				     counter++;
				 });
				 tds += '</tr>';
				 if ($('tbody', this).length > 0) {
				     $('tbody', this).append(tds);
				 } else {
				     $(this).append(tds);
				 }
				 $('body').outerWidth($('body').outerWidth()+200);
				 console.log($('body').outerWidth()+200);
			     });
				 postSort();
				$( function() {
				 $('.del').click(function () {
					 console.log($(this).closest('tr').remove());
					 postSort();
				});
				});
			});
			});

			//Delete a block step.
			$( function() {
			 $('.del').click(function () {
				 console.log($(this).closest('tr').remove());
				 postSort();
			});
			});
		</script>
	</head>
	<body>
<?php
include 'lhs.php';
echo LHS('programs'); //TODO:  Grab from server URI.
//Mainly a lot of parsing functions for the Intellus XML.
function inputNames($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=substr($matches[$i],1,-2);
	};
	return $input;
}
function grabRange($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<7;$i++) {
		$input[$i]=(float) filter_var(substr($matches[$i],1,-2),FILTER_SANITIZE_NUMBER_FLOAT,FILTER_FLAG_ALLOW_FRACTION);
	};
	return $input;
}
function inputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	$input[0]="C";
	for($i=0;$i<6;$i++) {
		$input[$i+1]=(!(strpos($matches[3*$i],'Off')))||(!(strpos($matches[3*$i+1],'Off')));
		if($input[$i+1]) {
			$input[$i+1]=substr($matches[3*$i+2],1,-2);
		};
	};
	return $input;
}
function outputCheck($string) {
	preg_match_all("/>[^<]+<\//",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$output[$i]=0;
		if(strpos($matches[$i],'On')) {
			$output[$i]=1;
		};
		if(strpos($matches[$i],'Dimming')) {
			$output[$i]=2;
		};
	};
	return $output;
}
function programNames($string) {
	preg_match_all("/Name>[^<]+<\/File/",$string,$matches);
	$matches=$matches[0];
	for($i=0;$i<count($matches);$i++) {
		$names[$i]=substr($matches[$i],5,-6);
	};
	return $names;
}
function stepCheck($string) {
	preg_match_all("/Start_Step_Error>[^<]+<\/Start_Step_Error/",$string,$matches);
	$matches=$matches[0];
	if(empty($matches)) {
		return 1;
	} else {
		return 0;
	};
};
function stepTime($string) {
	preg_match_all("/Time>[^<]+<\/Time/",$string,$matches);
	$matches=$matches[0][0];
	$time=intval(substr($matches,5,-6));
	$second=$time%60;
	$minute=(($time-$second*60)/60)%60;
	$hour=($time-$minute*60-$second*3600)/3600;
	if(strlen($minute)==1) {
		$minute="0".$minute;
	};
	if(strlen($hour)==1) {
		$hour="0".$hour;
	};
	$time=$hour.":".$minute;
	return $time;
};
function stepSP($string,$inputTags) {
	$SP=[];
	for($i=0;$i<7;$i++) {
		$j=$i+1;
		preg_match_all("/SP$j>[^<]+<\/SP$j/",$string,$matches);
		$matches=$matches[0][0];
		if($inputTags[$i]) {
			$SP[$i]=intval(substr($matches,4,-5))/1000;
		} else {
			$SP[$i]=0;//Default value.
		};
	};
	return $SP;
};
function stepEO($string,$eolist) {
	for($i=1;$i<48;$i++) {
		$EO[$i]=0;
	};
	foreach($eolist as $num) {
		preg_match_all("/EO$num>[^<]+<\/EO$num/",$string,$matches);
		$matches=substr($matches[0][0],4,-5);
		if($matches==="ON") {
			$matches=10000;
		} elseif($matches==="OFF") {
			$matches=0;
		} else {
			$matches=intval($matches)/100;
		};
		$EO[$num]=$matches;
	};
	return $EO;
};
function clock2Minutes($clockTime) {
	$hourMinute=explode(":",$clockTime);
	return 60*intval($hourMinute[1])+3600*intval($hourMinute[0]);
};
function stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO) {
	$str.="<tr><td><div class='tdelement'>Time<input name='time[]' type='time' value='$time' class='forceRight textField'></div></td>";
	for($i=0;$i<7;$i++) {
		if($inputTags[$i]) {
			$k=$i+1;
			$str.="<td><div class='tdelement'>{$inputNames[$i]} ({$inputTags[$i]}) <input name='SO{$k}[]' type='number' value='".$SP[$i]."' min='".$lowRangeTags[$i]."' max='".$highRangeTags[$i]."' class='forceRight textField'></div></td>";
		};
	};
	for($i=0;$i<5;$i++) {
		for($j=0;$j<count($outputCheck[$i]);$j++) {
			$num=$i*10+$j+1;
			if($outputCheck[$i][$j]==1) {
				if(isset($EO[$num])) {
					if($EO[$num]==="ON"||$EO[$num]===100||$EO[$num]==="100") {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON' selected>ON</option><option value='OFF'>OFF</option></select></div></td>";
					} else {
						$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
					};
				} else {
					$str.="<td><div class='tdelement'>Event $num<select name='EO{$num}[]' class='forceRight'><option value='ON'>ON</option><option value='OFF' selected>OFF</option></select></div></td>";
				};
				$eolist[]=$num;
			} else if($outputCheck[$i][$j]==2) {
				$eolist[]=$num;
				$str.="<td><div class='tdelement'>Dimm % $num<input name='EO{$num}[]' type='number' value='".$EO[$num]."' min='0' max='100' step='0.1' class='forceRight textField'></div></td>";
			};
		};
	};
	$str.="<td><div class='tdelement'><a href='#' class='del save'>Delete Step</a></div></td></tr>";
	return $str;
};
function toZero($num) {
	return 0;
};
//END FUNCTION DECLARATIONS

//IF USER DATA ENTERED, SEND IT OFF TO SAVE A PROGRAM.
if (!empty($_POST)) {
    //Grab user selected values.
    $posted = &$_POST;
    if(!empty($posted["name"])) {
	    $name=$posted['name'];
    } else {
	    $name="TEMP";
    };
    $ch=curl_init();
    if($posted['save']=='Run Program') {
	echo "Running Program $name.";
        $url="http://192.168.1.1/ramping.xml?Cmd=run&Item=file&Name=$name";
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_exec($ch);
    } else {
        $times=$posted['time'];
        $times=array_map('clock2Minutes',$times);
        $inputs=[];
        $events=[];
        for($i=1;$i<8;$i++) {
            if(!empty($posted["SO$i"])) {
                $so[$i]=$posted["SO$i"];
                $inputs[]=$i;
            };
        };
        $eolist=$posted['eolist'];

        $events=explode(',',$eolist);//Helps make some sections easier to code.
        for($i=1;$i<48;$i++) {
            if(!empty($posted["EO$i"])) {
                $eo[$i]=$posted["EO$i"];
                //$events[]=$i;
            };
        };
        
        //Delete previous program to replace it.
        curl_setopt($ch, CURLOPT_URL, "http://192.168.1.1/ramping.xml?Cmd=delete&Item=file&Name=$name");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_exec($ch);
        for($i=0;$i<sizeof($times);$i++) {
            //Send steps one by one...
            $step="&Time=".$times[$i];
            foreach($inputs as $k) {
                $in=$so[$k][$i]*1000;
                $step.="&SP$k=".$in;
            };
            foreach($events as $k) {
                if(empty($eo[$k][$i])) {
                    $eo[$k][$i]=0;
                } elseif($eo[$k][$i]=="OFF") {
                    $eo[$k][$i]=0;
                } elseif($eo[$k][$i]=="ON") {
                    $eo[$k][$i]=100;
                };
                $eo[$k][$i]=100*$eo[$k][$i];
                $step.="&EO$k=".$eo[$k][$i];
            };
            $url="http://192.168.1.1/ramping.xml?Cmd=add&Item=step&File=$name".$step;
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_exec($ch);
        };
    };
	curl_close($ch);
};


//GRAB CONTROLLER DATA TO CORRECTLY SET UP PROGRAMMER.
$programNames="http://192.168.1.1/ramping.xml?Cmd=read&Item=file_list";
$inputNames="http://192.168.1.1/read_data.xml?Cmd=read&Tag=AI_Name_1&Tag=AI_Name_2&Tag=AI_Name_3&Tag=AI_Name_4&Tag=AI_Name_5&Tag=AI_Name_6&Tag=AI_Name_7";
$inputTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_Method_2A&Tag=CLC_Method_2B&Tag=AI_Units_2&Tag=CLC_Method_3A&Tag=CLC_Method_3B&Tag=AI_Units_3&Tag=CLC_Method_4A&Tag=CLC_Method_4B&Tag=AI_Units_4&Tag=CLC_Method_5A&Tag=CLC_Method_5B&Tag=AI_Units_5&Tag=CLC_Method_6A&Tag=CLC_Method_6B&Tag=AI_Units_6&Tag=CLC_Method_7A&Tag=CLC_Method_7B&Tag=AI_Units_7";
$outputTags[0]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_1&Tag=DO_Function_2&Tag=DO_Function_3&Tag=DO_Function_4&Tag=DO_Function_5&Tag=DO_Function_6&Tag=DO_Function_7&Tag=DO_Function_8&Tag=DO_Function_9&Tag=DO_Function_10";
$outputTags[1]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_11&Tag=DO_Function_12&Tag=DO_Function_13&Tag=DO_Function_14&Tag=DO_Function_15&Tag=DO_Function_16&Tag=DO_Function_17&Tag=DO_Function_18&Tag=DO_Function_19&Tag=DO_Function_20";
$outputTags[2]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_21&Tag=DO_Function_22&Tag=DO_Function_23&Tag=DO_Function_24&Tag=DO_Function_25&Tag=DO_Function_26&Tag=DO_Function_27&Tag=DO_Function_28&Tag=DO_Function_29&Tag=DO_Function_30";
$outputTags[3]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_31&Tag=DO_Function_32&Tag=DO_Function_33&Tag=DO_Function_34&Tag=DO_Function_35&Tag=DO_Function_36&Tag=DO_Function_37&Tag=DO_Function_38&Tag=DO_Function_39&Tag=DO_Function_40";
$outputTags[4]="http://192.168.1.1/read_data.xml?Cmd=read&Tag=DO_Function_41&Tag=DO_Function_42&Tag=DO_Function_43&Tag=DO_Function_44&Tag=DO_Function_45&Tag=DO_Function_46&Tag=DO_Function_47";
$highRangeTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_SP_High_1&Tag=CLC_SP_High_2&Tag=CLC_SP_High_3&Tag=CLC_SP_High_4&Tag=CLC_SP_High_5&Tag=CLC_SP_High_6&Tag=CLC_SP_High_7";
$lowRangeTags="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CLC_SP_Low_1&Tag=CLC_SP_Low_2&Tag=CLC_SP_Low_3&Tag=CLC_SP_Low_4&Tag=CLC_SP_Low_5&Tag=CLC_SP_Low_6&Tag=CLC_SP_Low_7";
$manualCheck="http://192.168.1.1/read_data.xml?Cmd=read&Tag=CM_RAMPING_MODE";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $manualCheck);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$manualCheck=preg_match('/Manual/',curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $programNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$programNames=programNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputNames);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputNames=inputNames(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $highRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$highRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $lowRangeTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$lowRangeTags=grabRange(curl_exec($ch));
curl_setopt($ch, CURLOPT_URL, $inputTags);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
$inputTags=inputCheck(curl_exec($ch));


//START WRITING THE ACTUAL PAGE GIVEN CONTROLLER DATA--with exception of outputs to make writing easier.
$str="<form action='programs.php' method='post' enctype='multipart/form-data'>";
$str.="<select name='programSelect'>";
for($i=0;$i<count($programNames);$i++) {
	$str.="<option>".$programNames[$i]."</option>";
};
$str.="</select>";
$str.="<input type='submit' name='import' value='Import' class='save'>";
$str.="<BR>";
//IF THE IMPROT BUTTON WAS SELECTED, MAKE SURE TO GRAB THE IMPORTED PROGRAM.
if(isset($_POST['import'])) {
	$programSelect=$_POST['programSelect'];
	$str.="Program Name:  <input type='text' name='name' value='$programSelect' maxlength='8'>";
} else {
	$str.="Program Name:  <input type='text' name='name' maxlength='8'>";
};
$str.="<table id='program'><tbody><tr class='hideme'>";
$str.="<th id='time'>Time</th>";
for($i=0;$i<7;$i++) {
	if($inputTags[$i]) {
		$str.="<th>".$inputNames[$i]."</th>";
	};
};
//Stop, grab outputs.
$eolist=[];
for($i=0;$i<5;$i++) {
	curl_setopt($ch, CURLOPT_URL, $outputTags[$i]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$outputCheck[$i]=outputCheck(curl_exec($ch));
	for($j=0;$j<count($outputCheck[$i]);$j++) {
		$num=$i*10+$j+1;
		if($outputCheck[$i][$j]) {
			$str.="<th>Event {$num}</th>";
			$eolist[]=$num;
		};
	};
};
//O.k., back to imported program check.
$str.="<th>Edit</th></tr>";
if(isset($_POST['import'])) {
	$step=1;
	$check=1;
	while($check) {
		$programStep="http://192.168.1.1/ramping.xml?Cmd=read&Item=file&Name=$programSelect&Step=$step";
		curl_setopt($ch, CURLOPT_URL, $programStep);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		$programStep=curl_exec($ch);
		$check=stepCheck($programStep);
		if($check) {
			$time=stepTime($programStep);
			$SP=stepSP($programStep,$inputTags);
			$EO=stepEO($programStep,$eolist);
			$str=stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO);
		};
		$step++;
	};
} else {
	//If no imported program, set a default.
	$time='12:00';
	$SP=$lowRangeTags;
	$EO=array_map('toZero',$eolist);
	$str=stepWriter($str,$inputTags,$inputNames,$lowRangeTags,$highRangeTags,$outputCheck,$eolist,$time,$SP,$EO);
};
//Finish this nonsense up.
$str.="</tbody></table><BR>";
$str.="<a href='#' id='ins' class='save'>Add Step</a><BR>";
if($manualCheck) {
    $str.="<input type='submit' name='save' value='Save' class='save'>";
} else {
    $str.="<BR>(Please go to settings to change back to manual mode to save)<BR>";
};
$str.="<input type='submit' name='save' value='Run Program' class='save'>";
$eolist=implode(',',$eolist);
$str.="<input type='hidden' name='eolist' value='$eolist'>";
$str.="</form>";
//Generate Alarms modal.
	$str.="<div id='alarmsModal' class='modal'>";
	$str.="<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' aria-hidden='true' role='img' width='10em' height='10em' preserveAspectRatio='xMidYMid meet' viewBox='0 0 896 1024'><path d='M842 712l-20-25l-19.5-26l-19-29.5l-15-30l-11.5-33l-4-31.5V328q0-67-24-127.5t-64.5-104T567 27T446 1q-84 0-154.5 44T181 164t-40 164v209q0 18-5 36.5t-18 40t-20 32T72 681t-22 28l-18 25.5l-14 22l-10.5 22L5 798l5 21q17 33 83 33h183q0 71 50 121t121 50t121-50t50-121h187q66 0 81-33q4-7 4.5-14.5t0-13.5t-4.5-14.5t-7-14.5t-10.5-16t-12.5-16t-14-18zM447 956q-21 0-40-8.5t-33-22t-22.5-33T343 852h208q0 43-30.5 73.5T447 956zm358-172H81q6-10 24-34q1-2 20-27t25-33t21-32.5t20.5-39.5t11.5-38t6-43V328q0-108 68.5-183.5T446 69q29 0 56 7t50.5 19.5t44 30.5t37 40.5t28 47.5t17.5 54t6 60v209q0 31 9 62.5t27.5 61.5t32 48.5T789 755l4.5 6l4.5 5.5l5 6l4.5 5.5l4.5 6h-7z' fill='#3f796b'/></svg>
<BR><BR>";
	$str.="<div id='alarmsIndication'>";
	$str.="</div>";
	$str.="</div>";
//End Alarms modal.
echo $str;
echo "<BR>";
curl_close($ch);
?>
<script>
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	};
	});
setInterval(function(){
	var num=Math.random();
	$.get('alarms.txt?t='+num,function(data) {
	var regexValue=/>[^<]+<\//g;
	var regexFull=/<[^<]+<\//g;
	var alarmStatus=0;
	var alarmsIndication="Current Alarms:<BR>";
	dataFull=data.match(regexFull);
	data=data.match(regexValue).forEach((element,index)=>{
		if(index>1&&element.substring(1,element.length-2)!='Off') {
			alarmStatus=1;
			var moreRegex=/_/g;
			dataFull[index]=dataFull[index].substring(1,dataFull[index].length-2).replace('>',' - ').replace(moreRegex,' ');
			alarmsIndication+="<li>";
			alarmsIndication+=dataFull[index];
			alarmsIndication+="</li><BR>";
		};
	});
	if(alarmStatus==1) {
		document.getElementById('alarmsIndication').innerHTML=alarmsIndication;
		$('#alarmsModal').modal();
	} else {
		$.modal.close();
	};
	});
},60000);
</script>
	</body>
</html>

